/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.jna.linux;

import com.sun.jna.Pointer;
import dorkbox.jna.JNA;
import dorkbox.jna.linux.Gtk;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.jna.linux.structs.AppIndicatorInstanceStruct;
import dorkbox.os.OS;
import org.slf4j.LoggerFactory;

public class AppIndicator {
    public static final boolean isLoaded;
    public static final int CATEGORY_APPLICATION_STATUS = 0;
    public static final int STATUS_PASSIVE = 0;
    public static final int STATUS_ACTIVE = 1;

    public static String getInstallString(boolean bl) {
        if (bl) {
            if (OS.Linux.INSTANCE.isDebian()) {
                return "libappindicator1";
            }
            if (OS.Linux.INSTANCE.isFedora()) {
                return "libappindicator-gtk";
            }
            if (OS.Linux.INSTANCE.isArch()) {
                return "libappindicator-gtk2";
            }
            return "libappindicator";
        }
        if (OS.Linux.INSTANCE.isDebian()) {
            return "libappindicator3-1";
        }
        if (OS.Linux.INSTANCE.isFedora()) {
            return "libappindicator-gtk3";
        }
        if (OS.Linux.INSTANCE.isArch()) {
            return "libappindicator-gtk3";
        }
        return "libappindicator3";
    }

    public static native AppIndicatorInstanceStruct app_indicator_new(String var0, String var1, int var2);

    public static native void app_indicator_set_title(Pointer var0, String var1);

    public static native void app_indicator_set_status(Pointer var0, int var1);

    public static native void app_indicator_set_menu(Pointer var0, Pointer var1);

    public static native void app_indicator_set_icon(Pointer var0, String var1);

    static {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = bl = !OS.INSTANCE.isWindows() && !OS.INSTANCE.isMacOsX();
        if (!bl) {
            bl2 = true;
        }
        if (!Gtk.isLoaded) {
            bl = false;
            bl2 = true;
        }
        String[] stringArray = new String[]{"appindicator", "appindicator1", "appindicator-gtk"};
        String[] stringArray2 = new String[]{"appindicator3", "appindicator3-1", "appindicator-gtk3", "appindicator-gtk3-1"};
        if (Gtk.isGtk2) {
            for (String string : stringArray) {
                if (bl2) continue;
                try {
                    JNA.register(string, AppIndicator.class);
                    bl2 = true;
                    if (!GtkEventDispatch.DEBUG) continue;
                    LoggerFactory.getLogger(AppIndicator.class).debug("Loaded GTK2 library name '{}'.", (Object)string);
                }
                catch (Throwable throwable) {
                    if (!GtkEventDispatch.DEBUG) continue;
                    LoggerFactory.getLogger(AppIndicator.class).debug("Error loading GTK2 library name '{}'.", (Object)string, (Object)throwable);
                }
            }
        }
        if (Gtk.isGtk3) {
            for (String string : stringArray2) {
                if (bl2) continue;
                try {
                    JNA.register(string, AppIndicator.class);
                    bl2 = true;
                    if (!GtkEventDispatch.DEBUG) continue;
                    LoggerFactory.getLogger(AppIndicator.class).debug("Loaded GTK3 library name '{}'.", (Object)string);
                }
                catch (Throwable throwable) {
                    if (!GtkEventDispatch.DEBUG) continue;
                    LoggerFactory.getLogger(AppIndicator.class).debug("Error loading GTK3 library name '{}'.", (Object)string, (Object)throwable);
                }
            }
        }
        isLoaded = bl && bl2;
    }
}

