/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.jna.windows;

import com.sun.jna.Callback;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinDef;
import dorkbox.jna.windows.GetLastErrorException;
import dorkbox.jna.windows.Listener;
import dorkbox.jna.windows.MSG;
import dorkbox.jna.windows.User32;
import dorkbox.jna.windows.WNDPROC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsEventDispatch
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WindowsEventDispatch.class);
    private static final String NAME = "WindowsEventDispatch_";
    private static final AtomicInteger COUNT = new AtomicInteger(0);
    public static final int WM_TASKBARCREATED = User32.User32.RegisterWindowMessage(new WString("TaskbarCreated"));
    public static final int WM_COMMAND = 273;
    public static final int WM_SHELLNOTIFY = 1025;
    public static final int WM_MEASUREITEM = 44;
    public static final int WM_DRAWITEM = 43;
    public static final int MF_POPUP = 16;
    private final String name = "WindowsEventDispatch_" + COUNT.getAndIncrement();
    private final Map<Integer, List<Listener>> messageIDs = new HashMap<Integer, List<Listener>>();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private Thread dispatchThread;
    private WNDPROC WndProc;
    private volatile WinDef.HWND hWnd;

    private WindowsEventDispatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WindowsEventDispatch start() {
        WindowsEventDispatch windowsEventDispatch = new WindowsEventDispatch();
        Lock lock = windowsEventDispatch.lock;
        synchronized (lock) {
            windowsEventDispatch.start_();
            try {
                windowsEventDispatch.lock.lock();
                try {
                    windowsEventDispatch.condition.await();
                }
                finally {
                    windowsEventDispatch.lock.unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        return windowsEventDispatch;
    }

    public WinDef.HWND get() {
        return this.hWnd;
    }

    private void start_() {
        this.dispatchThread = new Thread((Runnable)this, this.name);
        this.dispatchThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.hWnd != null) {
                User32.User32.PostMessage(this.hWnd, 18, new WinDef.WPARAM(0L), new WinDef.LPARAM(0L));
                try {
                    if (!Thread.currentThread().equals(this.dispatchThread)) {
                        this.dispatchThread.join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(int n, Listener listener) {
        Map<Integer, List<Listener>> map = this.messageIDs;
        synchronized (map) {
            List<Listener> list = this.messageIDs.get(n);
            if (list == null) {
                list = new ArrayList<Listener>();
                this.messageIDs.put(n, list);
            }
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        Map<Integer, List<Listener>> map = this.messageIDs;
        synchronized (map) {
            for (Map.Entry<Integer, List<Listener>> entry : this.messageIDs.entrySet()) {
                List<Listener> list = entry.getValue();
                if (!list.remove(listener)) continue;
                return;
            }
        }
    }

    @Override
    public void run() {
        this.WndProc = new WNDPROC(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WinDef.LRESULT callback(WinDef.HWND hWND, int n, WinDef.WPARAM wPARAM, WinDef.LPARAM lPARAM) {
                ArrayList arrayList = null;
                Map map = WindowsEventDispatch.this.messageIDs;
                synchronized (map) {
                    arrayList = (ArrayList)WindowsEventDispatch.this.messageIDs.get(n);
                    if (arrayList != null) {
                        arrayList = new ArrayList(arrayList);
                    }
                }
                if (arrayList != null) {
                    for (Listener listener : arrayList) {
                        if (listener == null) continue;
                        try {
                            listener.run(hWND, wPARAM, lPARAM);
                        }
                        catch (Exception exception) {
                            logger.error("Error during listener execution.", (Throwable)exception);
                        }
                    }
                }
                return User32.User32.DefWindowProc(hWND, n, wPARAM, lPARAM);
            }
        };
        this.hWnd = User32.User32.CreateWindowEx(0, "STATIC", this.name, 0, 0, 0, 0, 0, null, null, null, null);
        if (this.hWnd == null) {
            throw new GetLastErrorException();
        }
        User32.User32.SetWindowLong(this.hWnd, -4, (Callback)this.WndProc);
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        MSG mSG = new MSG();
        while (User32.User32.GetMessage(mSG, null, 0, 0)) {
            User32.User32.TranslateMessage(mSG);
            User32.User32.DispatchMessage(mSG);
        }
        if (this.hWnd != null) {
            if (!User32.User32.DestroyWindow(this.hWnd)) {
                throw new GetLastErrorException();
            }
            this.hWnd = null;
        }
    }
}

