/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MnemonicHandler
implements KeyEventPostProcessor,
ChangeListener {
    private static boolean showMnemonics;
    private static WeakReference<Window> lastShowMnemonicWindow;
    private static WindowListener windowListener;
    private static int altPressedEventCount;
    private static boolean selectMenuOnAltReleased;

    MnemonicHandler() {
    }

    static boolean isShowMnemonics() {
        return showMnemonics || !UIManager.getBoolean("Component.hideMnemonics");
    }

    void install() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this);
        MenuSelectionManager.defaultManager().addChangeListener(this);
    }

    void uninstall() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this);
        MenuSelectionManager.defaultManager().removeChangeListener(this);
    }

    @Override
    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (SystemInfo.isMacOS) {
            if (n == 17 || n == 18) {
                MnemonicHandler.showMnemonics(this.shouldShowMnemonics(keyEvent) && keyEvent.isControlDown() && keyEvent.isAltDown(), keyEvent.getComponent());
            }
        } else {
            if (SystemInfo.isWindows) {
                return this.processKeyEventOnWindows(keyEvent);
            }
            if (n == 18) {
                MnemonicHandler.showMnemonics(this.shouldShowMnemonics(keyEvent), keyEvent.getComponent());
            }
        }
        return false;
    }

    private boolean shouldShowMnemonics(KeyEvent keyEvent) {
        return keyEvent.getID() == 401 || MenuSelectionManager.defaultManager().getSelectedPath().length > 0;
    }

    private boolean processKeyEventOnWindows(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 18) {
            selectMenuOnAltReleased = false;
            return false;
        }
        if (keyEvent.getID() == 401) {
            if (++altPressedEventCount == 1 && !keyEvent.isConsumed()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                boolean bl = selectMenuOnAltReleased = menuSelectionManager.getSelectedPath().length == 0;
                if (!selectMenuOnAltReleased) {
                    menuSelectionManager.clearSelectedPath();
                }
            }
            MnemonicHandler.showMnemonics(this.shouldShowMnemonics(keyEvent), keyEvent.getComponent());
            keyEvent.consume();
            return true;
        }
        if (keyEvent.getID() == 402) {
            MenuSelectionManager menuSelectionManager;
            altPressedEventCount = 0;
            boolean bl = false;
            if (selectMenuOnAltReleased && !keyEvent.isConsumed() && (menuSelectionManager = MenuSelectionManager.defaultManager()).getSelectedPath().length == 0) {
                Window window;
                JMenuBar jMenuBar;
                Component component = keyEvent.getComponent();
                JRootPane jRootPane = SwingUtilities.getRootPane(component);
                JMenuBar jMenuBar2 = jMenuBar = jRootPane != null ? jRootPane.getJMenuBar() : null;
                if (jMenuBar == null) {
                    window = SwingUtilities.getWindowAncestor(component);
                    if (window instanceof JFrame) {
                        jMenuBar = ((JFrame)window).getJMenuBar();
                    } else if (window instanceof JDialog) {
                        jMenuBar = ((JDialog)window).getJMenuBar();
                    }
                }
                Container container = window = jMenuBar != null ? jMenuBar.getMenu(0) : null;
                if (window != null) {
                    menuSelectionManager.setSelectedPath(new MenuElement[]{jMenuBar, window});
                    MnemonicHandler.showMnemonics(true, component);
                    bl = true;
                }
            }
            selectMenuOnAltReleased = false;
            if (!bl) {
                MnemonicHandler.showMnemonics(this.shouldShowMnemonics(keyEvent), keyEvent.getComponent());
            }
        }
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        if (menuElementArray.length == 0 && altPressedEventCount == 0) {
            MnemonicHandler.showMnemonics(false, null);
        }
    }

    static void showMnemonics(boolean bl, Component component) {
        if (bl == showMnemonics) {
            return;
        }
        showMnemonics = bl;
        if (!UIManager.getBoolean("Component.hideMnemonics")) {
            return;
        }
        if (bl) {
            JRootPane jRootPane = SwingUtilities.getRootPane(component);
            if (jRootPane == null) {
                return;
            }
            Window window = SwingUtilities.getWindowAncestor(jRootPane);
            if (window == null) {
                return;
            }
            MnemonicHandler.repaintMnemonics(window);
            windowListener = new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent windowEvent) {
                    altPressedEventCount = 0;
                    selectMenuOnAltReleased = false;
                    EventQueue.invokeLater(() -> MnemonicHandler.showMnemonics(false, null));
                }
            };
            window.addWindowListener(windowListener);
            lastShowMnemonicWindow = new WeakReference<Window>(window);
        } else if (lastShowMnemonicWindow != null) {
            Window window = (Window)lastShowMnemonicWindow.get();
            if (window != null) {
                MnemonicHandler.repaintMnemonics(window);
                if (windowListener != null) {
                    window.removeWindowListener(windowListener);
                    windowListener = null;
                }
            }
            lastShowMnemonicWindow = null;
        }
    }

    private static void repaintMnemonics(Container container) {
        for (Component component : container.getComponents()) {
            if (!component.isVisible()) continue;
            if (MnemonicHandler.hasMnemonic(component)) {
                component.repaint();
            }
            if (!(component instanceof Container)) continue;
            MnemonicHandler.repaintMnemonics((Container)component);
        }
    }

    private static boolean hasMnemonic(Component component) {
        if (component instanceof JLabel && ((JLabel)component).getDisplayedMnemonicIndex() >= 0) {
            return true;
        }
        if (component instanceof AbstractButton && ((AbstractButton)component).getDisplayedMnemonicIndex() >= 0) {
            return true;
        }
        if (component instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            int n = jTabbedPane.getTabCount();
            for (int i = 0; i < n; ++i) {
                if (jTabbedPane.getDisplayedMnemonicIndexAt(i) < 0) continue;
                return true;
            }
        }
        return false;
    }
}

