/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.UIManager;

public class FlatMenuArrowIcon
extends FlatAbstractIcon {
    @FlatStylingSupport.Styleable
    protected String arrowType = UIManager.getString("Component.arrowType");
    @FlatStylingSupport.Styleable
    protected Color arrowColor = UIManager.getColor("Menu.icon.arrowColor");
    @FlatStylingSupport.Styleable
    protected Color disabledArrowColor = UIManager.getColor("Menu.icon.disabledArrowColor");
    @FlatStylingSupport.Styleable
    protected Color selectionForeground = UIManager.getColor("Menu.selectionForeground");

    public FlatMenuArrowIcon() {
        super(6, 10, null);
    }

    public Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObject(this, string, object);
    }

    public Map<String, Class<?>> getStyleableInfos() {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    public Object getStyleableValue(String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    protected void paintIcon(Component component, Graphics2D graphics2D) {
        if (component != null && !component.getComponentOrientation().isLeftToRight()) {
            graphics2D.rotate(Math.toRadians(180.0), (double)this.width / 2.0, (double)this.height / 2.0);
        }
        graphics2D.setColor(this.getArrowColor(component));
        if (FlatUIUtils.isChevron(this.arrowType)) {
            Path2D path2D = FlatUIUtils.createPath(false, 1.0, 1.0, 5.0, 5.0, 1.0, 9.0);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(path2D);
        } else {
            graphics2D.fill(FlatUIUtils.createPath(0.0, 0.5, 5.0, 5.0, 0.0, 9.5));
        }
    }

    protected Color getArrowColor(Component component) {
        if (component instanceof JMenu && ((JMenu)component).isSelected() && !this.isUnderlineSelection()) {
            return this.selectionForeground;
        }
        return component == null || component.isEnabled() ? this.arrowColor : this.disabledArrowColor;
    }

    protected boolean isUnderlineSelection() {
        return "underline".equals(UIManager.getString("MenuItem.selectionType"));
    }
}

