/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.Map;
import javax.swing.UIManager;

public class FlatTabbedPaneCloseIcon
extends FlatAbstractIcon {
    @FlatStylingSupport.Styleable
    protected Dimension closeSize = UIManager.getDimension("TabbedPane.closeSize");
    @FlatStylingSupport.Styleable
    protected int closeArc = UIManager.getInt("TabbedPane.closeArc");
    @FlatStylingSupport.Styleable
    protected float closeCrossPlainSize = FlatUIUtils.getUIFloat("TabbedPane.closeCrossPlainSize", 7.5f);
    @FlatStylingSupport.Styleable
    protected float closeCrossFilledSize = FlatUIUtils.getUIFloat("TabbedPane.closeCrossFilledSize", this.closeCrossPlainSize);
    @FlatStylingSupport.Styleable
    protected float closeCrossLineWidth = FlatUIUtils.getUIFloat("TabbedPane.closeCrossLineWidth", 1.0f);
    @FlatStylingSupport.Styleable
    protected Color closeBackground = UIManager.getColor("TabbedPane.closeBackground");
    @FlatStylingSupport.Styleable
    protected Color closeForeground = UIManager.getColor("TabbedPane.closeForeground");
    @FlatStylingSupport.Styleable
    protected Color closeHoverBackground = UIManager.getColor("TabbedPane.closeHoverBackground");
    @FlatStylingSupport.Styleable
    protected Color closeHoverForeground = UIManager.getColor("TabbedPane.closeHoverForeground");
    @FlatStylingSupport.Styleable
    protected Color closePressedBackground = UIManager.getColor("TabbedPane.closePressedBackground");
    @FlatStylingSupport.Styleable
    protected Color closePressedForeground = UIManager.getColor("TabbedPane.closePressedForeground");

    public FlatTabbedPaneCloseIcon() {
        super(16, 16, null);
    }

    public Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObject(this, string, object);
    }

    public Map<String, Class<?>> getStyleableInfos() {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    public Object getStyleableValue(String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    protected void paintIcon(Component component, Graphics2D graphics2D) {
        Color color = FlatButtonUI.buttonStateColor(component, this.closeBackground, null, null, this.closeHoverBackground, this.closePressedBackground);
        if (color != null) {
            graphics2D.setColor(FlatUIUtils.deriveColor(color, component.getBackground()));
            graphics2D.fillRoundRect((this.width - this.closeSize.width) / 2, (this.height - this.closeSize.height) / 2, this.closeSize.width, this.closeSize.height, this.closeArc, this.closeArc);
        }
        Color color2 = FlatButtonUI.buttonStateColor(component, this.closeForeground, null, null, this.closeHoverForeground, this.closePressedForeground);
        graphics2D.setColor(FlatUIUtils.deriveColor(color2, component.getForeground()));
        float f = (float)this.width / 2.0f;
        float f2 = (float)this.height / 2.0f;
        float f3 = (color != null ? this.closeCrossFilledSize : this.closeCrossPlainSize) / 2.0f;
        Path2D.Float float_ = new Path2D.Float(0, 4);
        ((Path2D)float_).moveTo(f - f3, f2 - f3);
        ((Path2D)float_).lineTo(f + f3, f2 + f3);
        ((Path2D)float_).moveTo(f - f3, f2 + f3);
        ((Path2D)float_).lineTo(f + f3, f2 - f3);
        graphics2D.setStroke(new BasicStroke(this.closeCrossLineWidth));
        graphics2D.draw(float_);
    }
}

