/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.SwingUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class FlatOptionPaneUI
extends BasicOptionPaneUI {
    protected boolean showIcon;
    protected int iconMessageGap;
    protected int messagePadding;
    protected int maxCharactersPerLine;
    private int focusWidth;
    private boolean sameSizeButtons;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatOptionPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.showIcon = UIManager.getBoolean("OptionPane.showIcon");
        this.iconMessageGap = UIManager.getInt("OptionPane.iconMessageGap");
        this.messagePadding = UIManager.getInt("OptionPane.messagePadding");
        this.maxCharactersPerLine = UIManager.getInt("OptionPane.maxCharactersPerLine");
        this.focusWidth = UIManager.getInt("Component.focusWidth");
        this.sameSizeButtons = FlatUIUtils.getUIBoolean("OptionPane.sameSizeButtons", true);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener();
        return propertyChangeEvent -> {
            JRootPane jRootPane;
            propertyChangeListener.propertyChange(propertyChangeEvent);
            if (!this.showIcon && "ancestor".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() != null && (jRootPane = SwingUtilities.getRootPane(this.optionPane)) != null && jRootPane.getContentPane().getComponentCount() > 0 && jRootPane.getContentPane().getComponent(0) == this.optionPane) {
                jRootPane.putClientProperty("JRootPane.titleBarShowIcon", false);
            }
        };
    }

    @Override
    public Dimension getMinimumOptionPaneSize() {
        return UIScale.scale(super.getMinimumOptionPaneSize());
    }

    @Override
    protected int getMaxCharactersPerLineCount() {
        int n = super.getMaxCharactersPerLineCount();
        return this.maxCharactersPerLine > 0 && n == Integer.MAX_VALUE ? this.maxCharactersPerLine : n;
    }

    @Override
    protected Container createMessageArea() {
        Object t;
        Container container = super.createMessageArea();
        this.updateAreaPanel(container);
        this.updateKnownChildPanels(container);
        if (this.iconMessageGap > 0 && (t = SwingUtils.getComponentByName(container, "OptionPane.separator")) != null) {
            ((Component)t).setPreferredSize(new Dimension(UIScale.scale(this.iconMessageGap), 1));
        }
        return container;
    }

    @Override
    protected Container createButtonArea() {
        Container container = super.createButtonArea();
        this.updateAreaPanel(container);
        if (container.getLayout() instanceof BasicOptionPaneUI.ButtonAreaLayout) {
            BasicOptionPaneUI.ButtonAreaLayout buttonAreaLayout = (BasicOptionPaneUI.ButtonAreaLayout)container.getLayout();
            buttonAreaLayout.setPadding(UIScale.scale(buttonAreaLayout.getPadding() - this.focusWidth * 2));
        }
        return container;
    }

    @Override
    protected void addMessageComponents(Container container, GridBagConstraints gridBagConstraints, Object object, int n, boolean bl) {
        Box box;
        if (this.messagePadding > 0) {
            gridBagConstraints.insets.bottom = UIScale.scale(this.messagePadding);
        }
        if (object != null && !(object instanceof Component) && !(object instanceof Object[]) && !(object instanceof Icon) && BasicHTML.isHTMLString((String)(object = object.toString()))) {
            n = Integer.MAX_VALUE;
        }
        if (object instanceof Box && "OptionPane.verticalBox".equals((box = (Box)object).getName()) && box.getLayout() instanceof BoxLayout && ((BoxLayout)box.getLayout()).getAxis() == 1) {
            box.addPropertyChangeListener("componentOrientation", propertyChangeEvent -> {
                float f = box.getComponentOrientation().isLeftToRight() ? 0.0f : 1.0f;
                for (Component component : box.getComponents()) {
                    if (!(component instanceof JLabel) || !"OptionPane.label".equals(component.getName())) continue;
                    ((JLabel)component).setAlignmentX(f);
                }
            });
        }
        super.addMessageComponents(container, gridBagConstraints, object, n, bl);
    }

    private void updateAreaPanel(Container container) {
        if (!(container instanceof JPanel)) {
            return;
        }
        JPanel jPanel = (JPanel)container;
        jPanel.setBorder(FlatUIUtils.nonUIResource(jPanel.getBorder()));
        jPanel.setOpaque(false);
    }

    private void updateKnownChildPanels(Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof JPanel && component.getName() != null) {
                switch (component.getName()) {
                    case "OptionPane.realBody": 
                    case "OptionPane.body": 
                    case "OptionPane.separator": 
                    case "OptionPane.break": {
                        ((JPanel)component).setOpaque(false);
                    }
                }
            }
            if (!(component instanceof Container)) continue;
            this.updateKnownChildPanels((Container)component);
        }
    }

    @Override
    protected boolean getSizeButtonsToSameWidth() {
        return this.sameSizeButtons;
    }
}

