/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatLabelUI;
import com.formdev.flatlaf.ui.FlatNativeLinuxLibrary;
import com.formdev.flatlaf.ui.FlatNativeWindowBorder;
import com.formdev.flatlaf.ui.FlatRootPaneUI;
import com.formdev.flatlaf.ui.FlatTitlePaneIcon;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.JavaCompatibility2;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class FlatTitlePane
extends JComponent {
    static final String KEY_DEBUG_SHOW_RECTANGLES = "FlatLaf.debug.titlebar.showRectangles";
    private static final boolean isWindows_10 = SystemInfo.isWindows_10_orLater && !SystemInfo.isWindows_11_orLater;
    protected final Font titleFont;
    protected final Color activeBackground;
    protected final Color inactiveBackground;
    protected final Color activeForeground;
    protected final Color inactiveForeground;
    protected final Color embeddedForeground;
    protected final Color borderColor;
    protected final boolean showIcon;
    protected final boolean showIconInDialogs;
    protected final int noIconLeftGap;
    protected final Dimension iconSize;
    protected final int titleMinimumWidth;
    protected final int buttonMinimumWidth;
    protected final int buttonMaximizedHeight;
    protected final boolean centerTitle;
    protected final boolean centerTitleIfMenuBarEmbedded;
    protected final boolean showIconBesideTitle;
    protected final int menuBarTitleGap;
    protected final int menuBarTitleMinimumGap;
    protected final JRootPane rootPane;
    protected final String windowStyle;
    protected JPanel leftPanel;
    protected JLabel iconLabel;
    protected JComponent menuBarPlaceholder;
    protected JLabel titleLabel;
    protected JPanel buttonPanel;
    protected JButton iconifyButton;
    protected JButton maximizeButton;
    protected JButton restoreButton;
    protected JButton closeButton;
    protected Window window;
    private final Handler handler;
    final JPanel mouseLayer;
    final JPanel windowTopBorderLayer;
    private int laterCounter;
    private int lastCaptionHitTestX;
    private int lastCaptionHitTestY;
    private long lastCaptionHitTestTime;
    private boolean lastCaptionHitTestResult;
    private int debugTitleBarHeight;
    private Rectangle debugAppIconBounds;
    private Rectangle debugMinimizeButtonBounds;
    private Rectangle debugMaximizeButtonBounds;
    private Rectangle debugCloseButtonBounds;

    public FlatTitlePane(JRootPane jRootPane) {
        this.rootPane = jRootPane;
        Window window = SwingUtilities.getWindowAncestor(jRootPane);
        String string = window != null && window.getType() == Window.Type.UTILITY ? "small" : null;
        this.windowStyle = FlatClientProperties.clientProperty(jRootPane, "Window.style", string, String.class);
        this.titleFont = FlatUIUtils.getSubUIFont("TitlePane.font", this.windowStyle);
        this.activeBackground = FlatUIUtils.getSubUIColor("TitlePane.background", this.windowStyle);
        this.inactiveBackground = FlatUIUtils.getSubUIColor("TitlePane.inactiveBackground", this.windowStyle);
        this.activeForeground = FlatUIUtils.getSubUIColor("TitlePane.foreground", this.windowStyle);
        this.inactiveForeground = FlatUIUtils.getSubUIColor("TitlePane.inactiveForeground", this.windowStyle);
        this.embeddedForeground = FlatUIUtils.getSubUIColor("TitlePane.embeddedForeground", this.windowStyle);
        this.borderColor = UIManager.getColor("TitlePane.borderColor");
        this.showIcon = FlatUIUtils.getSubUIBoolean("TitlePane.showIcon", this.windowStyle, true);
        this.showIconInDialogs = FlatUIUtils.getSubUIBoolean("TitlePane.showIconInDialogs", this.windowStyle, true);
        this.noIconLeftGap = FlatUIUtils.getSubUIInt("TitlePane.noIconLeftGap", this.windowStyle, 8);
        this.iconSize = FlatUIUtils.getSubUIDimension("TitlePane.iconSize", this.windowStyle);
        this.titleMinimumWidth = FlatUIUtils.getSubUIInt("TitlePane.titleMinimumWidth", this.windowStyle, 60);
        this.buttonMinimumWidth = FlatUIUtils.getSubUIInt("TitlePane.buttonMinimumWidth", this.windowStyle, 30);
        this.buttonMaximizedHeight = FlatUIUtils.getSubUIInt("TitlePane.buttonMaximizedHeight", this.windowStyle, 0);
        this.centerTitle = FlatUIUtils.getSubUIBoolean("TitlePane.centerTitle", this.windowStyle, false);
        this.centerTitleIfMenuBarEmbedded = FlatUIUtils.getSubUIBoolean("TitlePane.centerTitleIfMenuBarEmbedded", this.windowStyle, true);
        this.showIconBesideTitle = FlatUIUtils.getSubUIBoolean("TitlePane.showIconBesideTitle", this.windowStyle, false);
        this.menuBarTitleGap = FlatUIUtils.getSubUIInt("TitlePane.menuBarTitleGap", this.windowStyle, 40);
        this.menuBarTitleMinimumGap = FlatUIUtils.getSubUIInt("TitlePane.menuBarTitleMinimumGap", this.windowStyle, 12);
        this.handler = this.createHandler();
        this.setBorder(this.createTitlePaneBorder());
        this.addSubComponents();
        this.activeChanged(true);
        this.mouseLayer = new JPanel();
        this.mouseLayer.setOpaque(false);
        this.mouseLayer.addMouseListener(this.handler);
        this.mouseLayer.addMouseMotionListener(this.handler);
        if (isWindows_10 && FlatNativeWindowBorder.isSupported()) {
            this.windowTopBorderLayer = new JPanel();
            this.windowTopBorderLayer.setVisible(false);
            this.windowTopBorderLayer.setOpaque(false);
            this.windowTopBorderLayer.setBorder(FlatUIUtils.nonUIResource(FlatNativeWindowBorder.WindowTopBorder.getInstance()));
        } else {
            this.windowTopBorderLayer = null;
        }
        this.applyComponentOrientation(jRootPane.getComponentOrientation());
    }

    protected FlatTitlePaneBorder createTitlePaneBorder() {
        return new FlatTitlePaneBorder();
    }

    protected Handler createHandler() {
        return new Handler();
    }

    protected void addSubComponents() {
        this.leftPanel = new JPanel();
        this.iconLabel = new JLabel();
        this.titleLabel = new JLabel(){

            @Override
            public void updateUI() {
                this.setUI(new FlatTitleLabelUI());
            }
        };
        this.iconLabel.setBorder(new FlatEmptyBorder(FlatUIUtils.getSubUIInsets("TitlePane.iconMargins", this.windowStyle)));
        this.titleLabel.setBorder(new FlatEmptyBorder(FlatUIUtils.getSubUIInsets("TitlePane.titleMargins", this.windowStyle)));
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 2));
        this.leftPanel.setOpaque(false);
        this.leftPanel.add(this.iconLabel);
        this.menuBarPlaceholder = new JComponent(){

            @Override
            public Dimension getPreferredSize() {
                JMenuBar jMenuBar = FlatTitlePane.this.rootPane.getJMenuBar();
                return FlatTitlePane.this.hasVisibleEmbeddedMenuBar(jMenuBar) ? jMenuBar.getPreferredSize() : new Dimension();
            }
        };
        this.leftPanel.add(this.menuBarPlaceholder);
        this.createButtons();
        this.setLayout(new BorderLayout(){

            @Override
            public void layoutContainer(Container container) {
                Component component;
                Serializable serializable;
                if (FlatTitlePane.this.isFullWindowContent()) {
                    super.layoutContainer(container);
                    return;
                }
                Insets insets = container.getInsets();
                int n = insets.left;
                int n2 = insets.top;
                int n3 = container.getWidth() - insets.left - insets.right;
                int n4 = container.getHeight() - insets.top - insets.bottom;
                int n5 = FlatTitlePane.this.leftPanel.getPreferredSize().width;
                int n6 = FlatTitlePane.this.buttonPanel.getPreferredSize().width;
                int n7 = n3 - n5 - n6;
                int n8 = UIScale.scale(FlatTitlePane.this.titleMinimumWidth);
                Icon icon = FlatTitlePane.this.titleLabel.getIcon();
                if (icon != null) {
                    serializable = FlatTitlePane.this.iconLabel.getInsets();
                    int n9 = FlatTitlePane.this.titleLabel.getComponentOrientation().isLeftToRight() ? serializable.right : serializable.left;
                    n8 += icon.getIconWidth() + n9;
                }
                if (n7 < n8) {
                    n6 = Math.max(n6 - (n8 - n7), FlatTitlePane.this.buttonPanel.getMinimumSize().width);
                    n7 = n3 - n5 - n6;
                }
                if (n7 < n8) {
                    int n10 = FlatTitlePane.this.iconLabel.isVisible() ? FlatTitlePane.this.iconLabel.getWidth() - FlatTitlePane.this.iconLabel.getInsets().right : UIScale.scale(FlatTitlePane.this.noIconLeftGap);
                    n5 = Math.max(n5 - (n8 - n7), n10);
                    n7 = n3 - n5 - n6;
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    FlatTitlePane.this.leftPanel.setBounds(n, n2, n5, n4);
                    FlatTitlePane.this.titleLabel.setBounds(n + n5, n2, n7, n4);
                    FlatTitlePane.this.buttonPanel.setBounds(n + n5 + n7, n2, n6, n4);
                } else {
                    FlatTitlePane.this.buttonPanel.setBounds(n, n2, n6, n4);
                    FlatTitlePane.this.titleLabel.setBounds(n + n6, n2, n7, n4);
                    FlatTitlePane.this.leftPanel.setBounds(n + n6 + n7, n2, n5, n4);
                }
                serializable = FlatTitlePane.this.rootPane.getJMenuBar();
                if (FlatTitlePane.this.hasVisibleEmbeddedMenuBar((JMenuBar)serializable) && (component = FlatTitlePane.this.findHorizontalGlue((JMenuBar)serializable)) != null) {
                    Point point = SwingUtilities.convertPoint(component, 0, 0, FlatTitlePane.this.titleLabel);
                    FlatTitlePane.this.titleLabel.setBounds(FlatTitlePane.this.titleLabel.getX() + point.x, FlatTitlePane.this.titleLabel.getY(), component.getWidth(), FlatTitlePane.this.titleLabel.getHeight());
                }
                FlatTitlePane.this.lastCaptionHitTestTime = 0L;
            }
        });
        this.add((Component)this.leftPanel, "Before");
        this.add((Component)this.titleLabel, "Center");
        this.add((Component)this.buttonPanel, "After");
    }

    protected void createButtons() {
        this.iconifyButton = this.createButton("TitlePane.iconifyIcon", "Iconify", actionEvent -> this.iconify());
        this.maximizeButton = this.createButton("TitlePane.maximizeIcon", "Maximize", actionEvent -> this.maximize());
        this.restoreButton = this.createButton("TitlePane.restoreIcon", "Restore", actionEvent -> this.restore());
        this.closeButton = this.createButton("TitlePane.closeIcon", "Close", actionEvent -> this.close());
        this.iconifyButton.setVisible(false);
        this.maximizeButton.setVisible(false);
        this.restoreButton.setVisible(false);
        this.buttonPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (FlatTitlePane.this.buttonMaximizedHeight > 0 && FlatTitlePane.this.isWindowMaximized() && !FlatTitlePane.this.hasVisibleEmbeddedMenuBar(FlatTitlePane.this.rootPane.getJMenuBar())) {
                    dimension = new Dimension(dimension.width, Math.min(dimension.height, UIScale.scale(FlatTitlePane.this.buttonMaximizedHeight)));
                }
                return dimension;
            }
        };
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        if (this.rootPane.getWindowDecorationStyle() == 1) {
            this.buttonPanel.add(this.iconifyButton);
            this.buttonPanel.add(this.maximizeButton);
            this.buttonPanel.add(this.restoreButton);
        }
        this.buttonPanel.add(this.closeButton);
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                FlatTitlePane.this.updateFullWindowContentButtonsBoundsProperty();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                FlatTitlePane.this.updateFullWindowContentButtonsBoundsProperty();
            }
        };
        this.buttonPanel.addComponentListener(componentAdapter);
        this.addComponentListener(componentAdapter);
    }

    protected JButton createButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(FlatUIUtils.getSubUIIcon(string, this.windowStyle)){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(UIScale.scale(FlatTitlePane.this.buttonMinimumWidth), super.getMinimumSize().height);
            }
        };
        jButton.setFocusable(false);
        jButton.setContentAreaFilled(false);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.putClientProperty("AccessibleName", string2);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    protected void activeChanged(boolean bl) {
        Color color;
        Color color2 = FlatClientProperties.clientPropertyColor(this.rootPane, "JRootPane.titleBarBackground", null);
        Color color3 = color = FlatClientProperties.clientPropertyColor(this.rootPane, "JRootPane.titleBarForeground", null);
        if (color2 == null) {
            color2 = FlatUIUtils.nonUIResource(bl ? this.activeBackground : this.inactiveBackground);
        }
        if (color == null) {
            color = FlatUIUtils.nonUIResource(bl ? this.activeForeground : this.inactiveForeground);
            color3 = bl && this.hasVisibleEmbeddedMenuBar(this.rootPane.getJMenuBar()) ? FlatUIUtils.nonUIResource(this.embeddedForeground) : color;
        }
        this.setBackground(color2);
        this.titleLabel.setForeground(color3);
        this.iconifyButton.setForeground(color);
        this.maximizeButton.setForeground(color);
        this.restoreButton.setForeground(color);
        this.closeButton.setForeground(color);
        this.iconifyButton.setBackground(color2);
        this.maximizeButton.setBackground(color2);
        this.restoreButton.setBackground(color2);
        this.closeButton.setBackground(color2);
    }

    protected void frameStateChanged() {
        if (this.window == null || this.rootPane.getWindowDecorationStyle() != 1) {
            return;
        }
        this.updateVisibility();
        if (this.window instanceof Frame) {
            Frame frame = (Frame)this.window;
            if (!(!this.isWindowMaximized() || SystemInfo.isLinux && FlatNativeLinuxLibrary.isWMUtilsSupported(this.window) || this.rootPane.getClientProperty("_flatlaf.maximizedBoundsUpToDate") != null)) {
                this.rootPane.putClientProperty("_flatlaf.maximizedBoundsUpToDate", null);
                Rectangle rectangle = frame.getMaximizedBounds();
                this.updateMaximizedBounds();
                Rectangle rectangle2 = frame.getMaximizedBounds();
                if (rectangle2 != null && !rectangle2.equals(rectangle)) {
                    int n = frame.getExtendedState();
                    frame.setExtendedState(n & 0xFFFFFFF9);
                    frame.setExtendedState(n);
                }
            }
        }
    }

    protected void updateVisibility() {
        boolean bl = this.isFullWindowContent();
        this.leftPanel.setVisible(!bl);
        this.titleLabel.setVisible(FlatClientProperties.clientPropertyBoolean(this.rootPane, "JRootPane.titleBarShowTitle", true) && !bl);
        this.closeButton.setVisible(FlatClientProperties.clientPropertyBoolean(this.rootPane, "JRootPane.titleBarShowClose", true));
        if (this.window instanceof Frame) {
            Frame frame = (Frame)this.window;
            boolean bl2 = frame.isResizable() && FlatClientProperties.clientPropertyBoolean(this.rootPane, "JRootPane.titleBarShowMaximize", true);
            boolean bl3 = this.isWindowMaximized();
            this.iconifyButton.setVisible(FlatClientProperties.clientPropertyBoolean(this.rootPane, "JRootPane.titleBarShowIconify", true));
            this.maximizeButton.setVisible(bl2 && !bl3);
            this.restoreButton.setVisible(bl2 && bl3);
        } else {
            this.iconifyButton.setVisible(false);
            this.maximizeButton.setVisible(false);
            this.restoreButton.setVisible(false);
        }
    }

    protected void updateIcon() {
        boolean bl = this.showIcon;
        if (!this.showIconInDialogs && this.rootPane.getParent() instanceof JDialog) {
            bl = false;
        }
        List<Image> list = null;
        if (FlatClientProperties.clientPropertyBoolean(this.rootPane, "JRootPane.titleBarShowIcon", bl) && !this.isFullWindowContent() && (list = this.window.getIconImages()).isEmpty()) {
            for (Window window = this.window.getOwner(); window != null && (list = window.getIconImages()).isEmpty(); window = window.getOwner()) {
            }
        }
        boolean bl2 = list != null && !list.isEmpty();
        this.iconLabel.setIcon(bl2 && !this.showIconBesideTitle ? new FlatTitlePaneIcon(list, this.iconSize) : null);
        this.titleLabel.setIcon(bl2 && this.showIconBesideTitle ? new FlatTitlePaneIcon(list, this.iconSize) : null);
        this.iconLabel.setVisible(bl2 && !this.showIconBesideTitle);
        this.leftPanel.setBorder(bl2 && !this.showIconBesideTitle ? null : FlatUIUtils.nonUIResource(new FlatEmptyBorder(0, this.noIconLeftGap, 0, 0)));
        this.updateNativeTitleBarHeightAndHitTestSpotsLater();
    }

    void updateFullWindowContentButtonsBoundsProperty() {
        Rectangle rectangle = this.isFullWindowContent() ? new Rectangle(SwingUtilities.convertPoint(this.buttonPanel, 0, 0, this.rootPane), this.buttonPanel.getSize()) : null;
        this.rootPane.putClientProperty("FlatLaf.fullWindowContent.buttonsBounds", rectangle);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallWindowListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            this.frameStateChanged();
            this.activeChanged(this.window.isActive());
            this.updateIcon();
            this.titleLabel.setText(this.getWindowTitle());
            this.installWindowListeners();
        }
        this.updateNativeTitleBarHeightAndHitTestSpotsLater();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallWindowListeners();
        this.window = null;
    }

    protected String getWindowTitle() {
        if (this.window instanceof Frame) {
            return ((Frame)this.window).getTitle();
        }
        if (this.window instanceof Dialog) {
            return ((Dialog)this.window).getTitle();
        }
        return null;
    }

    protected void installWindowListeners() {
        if (this.window == null) {
            return;
        }
        this.window.addPropertyChangeListener(this.handler);
        this.window.addWindowListener(this.handler);
        this.window.addWindowStateListener(this.handler);
        this.window.addComponentListener(this.handler);
    }

    protected void uninstallWindowListeners() {
        if (this.window == null) {
            return;
        }
        this.window.removePropertyChangeListener(this.handler);
        this.window.removeWindowListener(this.handler);
        this.window.removeWindowStateListener(this.handler);
        this.window.removeComponentListener(this.handler);
    }

    protected boolean isFullWindowContent() {
        return FlatRootPaneUI.isFullWindowContent(this.rootPane);
    }

    protected boolean hasVisibleEmbeddedMenuBar(JMenuBar jMenuBar) {
        return jMenuBar != null && jMenuBar.isVisible() && this.isMenuBarEmbedded();
    }

    protected boolean isMenuBarEmbedded() {
        if (this.isFullWindowContent()) {
            return false;
        }
        return FlatUIUtils.getBoolean(this.rootPane, "flatlaf.menuBarEmbedded", "JRootPane.menuBarEmbedded", "TitlePane.menuBarEmbedded", false);
    }

    protected Rectangle getMenuBarBounds() {
        Insets insets = this.rootPane.getInsets();
        Rectangle rectangle = new Rectangle(SwingUtilities.convertPoint(this.menuBarPlaceholder, -insets.left, -insets.top, this.rootPane), this.menuBarPlaceholder.getSize());
        Insets insets2 = this.getBorder().getBorderInsets(this);
        rectangle.height += insets2.bottom;
        Component component = this.findHorizontalGlue(this.rootPane.getJMenuBar());
        if (component != null) {
            boolean bl = this.getComponentOrientation().isLeftToRight();
            int n = bl ? this.buttonPanel.getX() - (this.leftPanel.getX() + this.leftPanel.getWidth()) : this.leftPanel.getX() - (this.buttonPanel.getX() + this.buttonPanel.getWidth());
            n = Math.max(n, 0);
            rectangle.width += n;
            if (!bl) {
                rectangle.x -= n;
            }
        }
        return rectangle;
    }

    protected Component findHorizontalGlue(JMenuBar jMenuBar) {
        if (jMenuBar == null) {
            return null;
        }
        int n = jMenuBar.getComponentCount();
        for (int i = n - 1; i >= 0; --i) {
            Component component = jMenuBar.getComponent(i);
            if (!(component instanceof Box.Filler) || component.getMaximumSize().width < Short.MAX_VALUE) continue;
            return component;
        }
        return null;
    }

    protected void titleBarColorsChanged() {
        this.activeChanged(this.window == null || this.window.isActive());
        this.repaint();
    }

    protected void menuBarChanged() {
        this.menuBarPlaceholder.invalidate();
        this.repaint();
        EventQueue.invokeLater(() -> this.activeChanged(this.window == null || this.window.isActive()));
    }

    protected void menuBarLayouted() {
        this.updateNativeTitleBarHeightAndHitTestSpotsLater();
        this.doLayout();
    }

    void menuBarInvalidate() {
        this.menuBarPlaceholder.invalidate();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!UIManager.getBoolean(KEY_DEBUG_SHOW_RECTANGLES)) {
            return;
        }
        if (this.debugTitleBarHeight > 0) {
            int n = SwingUtilities.convertPoint((Component)this.window, (int)0, (int)this.debugTitleBarHeight, (Component)this).y;
            graphics.setColor(Color.green);
            graphics.drawLine(0, n, this.getWidth(), n);
        }
        graphics.setColor(Color.red);
        this.debugPaintComponentWithMouseListener(graphics, Color.red, this.rootPane.getLayeredPane(), 0, 0);
        this.debugPaintRect(graphics, Color.blue, this.debugAppIconBounds);
        this.debugPaintRect(graphics, Color.blue, this.debugMinimizeButtonBounds);
        this.debugPaintRect(graphics, Color.magenta, this.debugMaximizeButtonBounds);
        this.debugPaintRect(graphics, Color.cyan, this.debugCloseButtonBounds);
    }

    private void debugPaintComponentWithMouseListener(Graphics graphics, Color color, Component component, int n, int n2) {
        if (!component.isDisplayable() || !component.isVisible() || component == this.mouseLayer || component == this.iconifyButton || component == this.maximizeButton || component == this.restoreButton || component == this.closeButton) {
            return;
        }
        if (component.getMouseListeners().length > 0 || component.getMouseMotionListeners().length > 0 || component.getMouseWheelListeners().length > 0) {
            graphics.drawRect(n, n2, component.getWidth(), component.getHeight());
            return;
        }
        if (component instanceof Container) {
            Rectangle rectangle = SwingUtilities.convertRectangle(this, new Rectangle(this.getSize()), this.window);
            for (Component component2 : ((Container)component).getComponents()) {
                Rectangle rectangle2 = SwingUtilities.convertRectangle(component, new Rectangle(component.getSize()), this.window);
                if (!rectangle2.intersects(rectangle)) continue;
                this.debugPaintComponentWithMouseListener(graphics, color, component2, n + component2.getX(), n2 + component2.getY());
            }
        }
    }

    private void debugPaintRect(Graphics graphics, Color color, Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        graphics.setColor(color);
        Point point = SwingUtilities.convertPoint(this, 0, 0, this.window);
        graphics.drawRect(rectangle.x - point.x, rectangle.y - point.y, rectangle.width - 1, rectangle.height - 1);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isFullWindowContent()) {
            return;
        }
        graphics.setColor(UIManager.getBoolean("TitlePane.unifiedBackground") && FlatClientProperties.clientPropertyColor(this.rootPane, "JRootPane.titleBarBackground", null) == null ? FlatUIUtils.getParentBackground(this) : this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected void repaintWindowBorder() {
        int n = this.rootPane.getWidth();
        int n2 = this.rootPane.getHeight();
        Insets insets = this.rootPane.getInsets();
        this.rootPane.repaint(0, 0, n, insets.top);
        this.rootPane.repaint(0, 0, insets.left, n2);
        this.rootPane.repaint(0, n2 - insets.bottom, n, insets.bottom);
        this.rootPane.repaint(n - insets.right, 0, insets.right, n2);
    }

    protected void iconify() {
        if (!(this.window instanceof Frame)) {
            return;
        }
        Frame frame = (Frame)this.window;
        if (!FlatNativeWindowBorder.showWindow(this.window, 6)) {
            frame.setExtendedState(frame.getExtendedState() | 1);
        }
    }

    protected boolean isWindowMaximized() {
        return this.window instanceof Frame && (((Frame)this.window).getExtendedState() & 6) == 6;
    }

    protected void maximize() {
        if (!(this.window instanceof Frame)) {
            return;
        }
        Frame frame = (Frame)this.window;
        this.updateMaximizedBounds();
        this.rootPane.putClientProperty("_flatlaf.maximizedBoundsUpToDate", true);
        if (!FlatNativeWindowBorder.showWindow(frame, 3)) {
            int n = frame.getExtendedState();
            int n2 = n | 6;
            if (SystemInfo.isLinux && (n & 6) == 4) {
                n2 = n & 0xFFFFFFF9 | 2;
            }
            frame.setExtendedState(n2);
        }
    }

    protected void updateMaximizedBounds() {
        Frame frame = (Frame)this.window;
        Rectangle rectangle = frame.getMaximizedBounds();
        if (!this.hasNativeCustomDecoration() && (rectangle == null || Objects.equals(rectangle, this.rootPane.getClientProperty("_flatlaf.maximizedBounds")))) {
            Cloneable cloneable;
            GraphicsConfiguration graphicsConfiguration = this.window.getGraphicsConfiguration();
            Rectangle rectangle2 = graphicsConfiguration.getBounds();
            int n = rectangle2.x;
            int n2 = rectangle2.y;
            int n3 = rectangle2.width;
            int n4 = rectangle2.height;
            if (SystemInfo.isWindows && !this.isMaximizedBoundsFixed()) {
                n = 0;
                n2 = 0;
                cloneable = graphicsConfiguration.getDefaultTransform();
                n3 = (int)((double)n3 * ((AffineTransform)cloneable).getScaleX());
                n4 = (int)((double)n4 * ((AffineTransform)cloneable).getScaleY());
            }
            cloneable = this.window.getToolkit().getScreenInsets(graphicsConfiguration);
            Rectangle rectangle3 = new Rectangle(n + ((Insets)cloneable).left, n2 + ((Insets)cloneable).top, n3 - ((Insets)cloneable).left - ((Insets)cloneable).right, n4 - ((Insets)cloneable).top - ((Insets)cloneable).bottom);
            if (!Objects.equals(rectangle, rectangle3)) {
                frame.setMaximizedBounds(rectangle3);
                this.rootPane.putClientProperty("_flatlaf.maximizedBounds", rectangle3);
            }
        }
    }

    private boolean isMaximizedBoundsFixed() {
        return SystemInfo.isJava_15_orLater || SystemInfo.javaVersion >= SystemInfo.toVersion(11, 0, 8, 0) && SystemInfo.javaVersion < SystemInfo.toVersion(12, 0, 0, 0) || SystemInfo.javaVersion >= SystemInfo.toVersion(13, 0, 4, 0) && SystemInfo.javaVersion < SystemInfo.toVersion(14, 0, 0, 0);
    }

    protected void restore() {
        if (!(this.window instanceof Frame)) {
            return;
        }
        Frame frame = (Frame)this.window;
        if (!FlatNativeWindowBorder.showWindow(this.window, 9)) {
            int n = frame.getExtendedState();
            frame.setExtendedState((n & 1) != 0 ? n & 0xFFFFFFFE : n & 0xFFFFFFF9);
        }
    }

    private void maximizeOrRestore() {
        if (!(this.window instanceof Frame) || !((Frame)this.window).isResizable()) {
            return;
        }
        if (this.isWindowMaximized()) {
            this.restore();
        } else {
            this.maximize();
        }
    }

    protected void close() {
        if (this.window != null) {
            this.window.dispatchEvent(new WindowEvent(this.window, 201));
        }
    }

    protected boolean hasNativeCustomDecoration() {
        return this.window != null && FlatNativeWindowBorder.hasCustomDecoration(this.window);
    }

    boolean isWindowTopBorderNeeded() {
        return isWindows_10 && this.hasNativeCustomDecoration();
    }

    protected void updateNativeTitleBarHeightAndHitTestSpotsLater() {
        ++this.laterCounter;
        EventQueue.invokeLater(() -> {
            --this.laterCounter;
            if (this.laterCounter == 0) {
                this.updateNativeTitleBarHeightAndHitTestSpots();
            }
        });
    }

    protected void updateNativeTitleBarHeightAndHitTestSpots() {
        Rectangle rectangle;
        Cloneable cloneable;
        Object object;
        Serializable serializable;
        if (!this.isDisplayable()) {
            return;
        }
        if (!this.hasNativeCustomDecoration()) {
            return;
        }
        int n = this.getHeight();
        for (serializable = this; serializable != this.window && serializable != null; serializable = serializable.getParent()) {
            n += ((Component)serializable).getY();
        }
        if (n > 0) {
            --n;
        }
        serializable = null;
        if (!this.showIconBesideTitle && this.iconLabel.isVisible()) {
            object = SwingUtilities.convertPoint(this.iconLabel, 0, 0, this.window);
            cloneable = this.iconLabel.getInsets();
            rectangle = new Rectangle(((Point)object).x + cloneable.left - 1, ((Point)object).y + cloneable.top - 1, this.iconLabel.getWidth() - cloneable.left - cloneable.right + 2, this.iconLabel.getHeight() - cloneable.top - cloneable.bottom + 2);
            if (this.isWindowMaximized()) {
                rectangle.height += rectangle.y;
                rectangle.y = 0;
                if (this.window.getComponentOrientation().isLeftToRight()) {
                    rectangle.width += rectangle.x;
                    rectangle.x = 0;
                } else {
                    rectangle.width += cloneable.right;
                }
            }
            serializable = rectangle;
        } else if (this.showIconBesideTitle && this.titleLabel.getIcon() != null && this.titleLabel.getUI() instanceof FlatTitleLabelUI) {
            object = (FlatTitleLabelUI)this.titleLabel.getUI();
            cloneable = this.titleLabel.getInsets();
            rectangle = new Rectangle(cloneable.left, cloneable.top, this.titleLabel.getWidth() - cloneable.left - cloneable.right, this.titleLabel.getHeight() - cloneable.top - cloneable.bottom);
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            ((FlatTitleLabelUI)object).layoutCL(this.titleLabel, this.titleLabel.getFontMetrics(this.titleLabel.getFont()), this.titleLabel.getText(), this.titleLabel.getIcon(), rectangle, rectangle2, rectangle3);
            if (rectangle2.x == 0) {
                Point point = SwingUtilities.convertPoint(this.titleLabel, 0, 0, this.window);
                rectangle2.x += point.x;
                rectangle2.y += point.y;
                --rectangle2.x;
                --rectangle2.y;
                rectangle2.width += 2;
                rectangle2.height += 2;
                serializable = rectangle2;
            }
        }
        object = this.boundsInWindow(this.iconifyButton);
        cloneable = this.boundsInWindow(this.maximizeButton.isVisible() ? this.maximizeButton : this.restoreButton);
        rectangle = this.boundsInWindow(this.closeButton);
        this.lastCaptionHitTestTime = 0L;
        FlatNativeWindowBorder.setTitleBarHeightAndHitTestSpots(this.window, n, this::captionHitTest, (Rectangle)serializable, (Rectangle)object, (Rectangle)cloneable, rectangle);
        this.debugTitleBarHeight = n;
        this.debugAppIconBounds = serializable;
        this.debugMinimizeButtonBounds = object;
        this.debugMaximizeButtonBounds = cloneable;
        this.debugCloseButtonBounds = rectangle;
        if (UIManager.getBoolean(KEY_DEBUG_SHOW_RECTANGLES)) {
            this.repaint();
        }
    }

    private Rectangle boundsInWindow(JComponent jComponent) {
        return jComponent.isShowing() ? SwingUtilities.convertRectangle(jComponent.getParent(), jComponent.getBounds(), this.window) : null;
    }

    private boolean captionHitTest(Point point) {
        long l = System.currentTimeMillis();
        if (point.x == this.lastCaptionHitTestX && point.y == this.lastCaptionHitTestY && l < this.lastCaptionHitTestTime + 300L) {
            this.lastCaptionHitTestTime = l;
            return this.lastCaptionHitTestResult;
        }
        JLayeredPane jLayeredPane = this.rootPane.getLayeredPane();
        int n = point.x;
        int n2 = point.y;
        for (Container container = jLayeredPane; container != this.window && container != null; container = container.getParent()) {
            n -= ((Component)container).getX();
            n2 -= ((Component)container).getY();
        }
        this.lastCaptionHitTestX = point.x;
        this.lastCaptionHitTestY = point.y;
        this.lastCaptionHitTestTime = l;
        this.lastCaptionHitTestResult = this.isTitleBarCaptionAt(jLayeredPane, n, n2);
        return this.lastCaptionHitTestResult;
    }

    private boolean isTitleBarCaptionAt(Component component, int n, int n2) {
        if (!(component.isDisplayable() && component.isVisible() && component.contains(n, n2) && component != this.mouseLayer)) {
            return true;
        }
        if (component.isEnabled() && (component.getMouseListeners().length > 0 || component.getMouseMotionListeners().length > 0)) {
            Boolean bl;
            Object object;
            if (!(component instanceof JComponent)) {
                return false;
            }
            Object object2 = ((JComponent)component).getClientProperty("JComponent.titleBarCaption");
            if (object2 instanceof Boolean) {
                return (Boolean)object2;
            }
            if (!component.isValid()) {
                return false;
            }
            if (object2 instanceof Function) {
                object = (Function)object2;
                bl = (Boolean)object.apply(new Point(n, n2));
                if (bl != null) {
                    return bl;
                }
            } else {
                object = JavaCompatibility2.getUI((JComponent)component);
                if (!(object instanceof TitleBarCaptionHitTest)) {
                    return false;
                }
                bl = ((TitleBarCaptionHitTest)object).isTitleBarCaptionAt(n, n2);
                if (bl != null) {
                    return bl;
                }
            }
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                if (this.isTitleBarCaptionAt(component2, n - component2.getX(), n2 - component2.getY())) continue;
                return false;
            }
        }
        return true;
    }

    public static interface TitleBarCaptionHitTest {
        public Boolean isTitleBarCaptionAt(int var1, int var2);
    }

    protected class Handler
    extends WindowAdapter
    implements ComponentListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener {
        private Point dragOffset;
        private boolean linuxNativeMove;
        private long lastSingleClickWhen;

        protected Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            switch (propertyChangeEvent.getPropertyName()) {
                case "title": {
                    FlatTitlePane.this.titleLabel.setText(FlatTitlePane.this.getWindowTitle());
                    break;
                }
                case "resizable": {
                    if (!(FlatTitlePane.this.window instanceof Frame)) break;
                    FlatTitlePane.this.frameStateChanged();
                    break;
                }
                case "iconImage": {
                    FlatTitlePane.this.updateIcon();
                    break;
                }
                case "componentOrientation": {
                    FlatTitlePane.this.updateNativeTitleBarHeightAndHitTestSpotsLater();
                }
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            FlatTitlePane.this.activeChanged(true);
            FlatTitlePane.this.updateNativeTitleBarHeightAndHitTestSpots();
            if (FlatTitlePane.this.isWindowTopBorderNeeded()) {
                FlatNativeWindowBorder.WindowTopBorder.getInstance().repaintBorder(FlatTitlePane.this);
            }
            FlatTitlePane.this.repaintWindowBorder();
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            FlatTitlePane.this.activeChanged(false);
            FlatTitlePane.this.updateNativeTitleBarHeightAndHitTestSpots();
            if (FlatTitlePane.this.isWindowTopBorderNeeded()) {
                FlatNativeWindowBorder.WindowTopBorder.getInstance().repaintBorder(FlatTitlePane.this);
            }
            FlatTitlePane.this.repaintWindowBorder();
        }

        @Override
        public void windowStateChanged(WindowEvent windowEvent) {
            FlatTitlePane.this.frameStateChanged();
            FlatTitlePane.this.updateNativeTitleBarHeightAndHitTestSpots();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.linuxNativeMove && SystemInfo.isLinux && FlatNativeLinuxLibrary.isWMUtilsSupported(FlatTitlePane.this.window)) {
                if (this.lastSingleClickWhen != 0L && mouseEvent.getWhen() - this.lastSingleClickWhen <= (long)this.getMultiClickInterval()) {
                    this.lastSingleClickWhen = 0L;
                    FlatTitlePane.this.maximizeOrRestore();
                }
                return;
            }
            if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (SwingUtilities.getDeepestComponentAt(FlatTitlePane.this, mouseEvent.getX(), mouseEvent.getY()) == FlatTitlePane.this.iconLabel) {
                    FlatTitlePane.this.close();
                } else if (!FlatTitlePane.this.hasNativeCustomDecoration()) {
                    FlatTitlePane.this.maximizeOrRestore();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (FlatTitlePane.this.window == null) {
                return;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent) && SystemInfo.isLinux && FlatNativeLinuxLibrary.isWMUtilsSupported(FlatTitlePane.this.window)) {
                mouseEvent.consume();
                FlatNativeLinuxLibrary.showWindowMenu(FlatTitlePane.this.window, mouseEvent);
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            this.dragOffset = SwingUtilities.convertPoint(FlatTitlePane.this.mouseLayer, mouseEvent.getPoint(), FlatTitlePane.this.window);
            this.linuxNativeMove = false;
            if (SystemInfo.isLinux && FlatNativeLinuxLibrary.isWMUtilsSupported(FlatTitlePane.this.window)) {
                int n = mouseEvent.getClickCount();
                if (n == 1 && this.lastSingleClickWhen != 0L && mouseEvent.getWhen() - this.lastSingleClickWhen <= (long)this.getMultiClickInterval()) {
                    n = 2;
                }
                switch (n) {
                    case 1: {
                        mouseEvent.consume();
                        this.linuxNativeMove = FlatNativeLinuxLibrary.moveOrResizeWindow(FlatTitlePane.this.window, mouseEvent, 8);
                        this.lastSingleClickWhen = mouseEvent.getWhen();
                        break;
                    }
                    case 2: {
                        this.lastSingleClickWhen = 0L;
                        FlatTitlePane.this.maximizeOrRestore();
                    }
                }
            }
        }

        private int getMultiClickInterval() {
            Object object = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
            return object instanceof Integer ? (Integer)object : 500;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Frame frame;
            int n;
            if (FlatTitlePane.this.window == null || this.dragOffset == null) {
                return;
            }
            if (this.linuxNativeMove) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (FlatTitlePane.this.hasNativeCustomDecoration()) {
                return;
            }
            if (FlatTitlePane.this.window instanceof Frame && ((n = (frame = (Frame)FlatTitlePane.this.window).getExtendedState()) & 6) != 0) {
                int n2 = FlatTitlePane.this.window.getWidth();
                frame.setExtendedState(n & 0xFFFFFFF9);
                int n3 = FlatTitlePane.this.window.getWidth();
                int n4 = n3 / 2;
                if (this.dragOffset.x > n4) {
                    this.dragOffset.x = this.dragOffset.x > n2 - n4 ? n3 - (n2 - this.dragOffset.x) : n4;
                }
            }
            int n5 = mouseEvent.getXOnScreen() - this.dragOffset.x;
            n = mouseEvent.getYOnScreen() - this.dragOffset.y;
            if (n5 == FlatTitlePane.this.window.getX() && n == FlatTitlePane.this.window.getY()) {
                return;
            }
            FlatTitlePane.this.window.setLocation(n5, n);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            FlatTitlePane.this.updateNativeTitleBarHeightAndHitTestSpotsLater();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            FlatTitlePane.this.frameStateChanged();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    protected class FlatTitleLabelUI
    extends FlatLabelUI {
        protected FlatTitleLabelUI() {
            super(false);
        }

        @Override
        protected void installDefaults(JLabel jLabel) {
            super.installDefaults(jLabel);
            if (FlatTitlePane.this.titleFont != null) {
                jLabel.setFont(FlatTitlePane.this.titleFont);
            }
        }

        @Override
        protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
            Object object;
            int n;
            JMenuBar jMenuBar = FlatTitlePane.this.rootPane.getJMenuBar();
            boolean bl = FlatTitlePane.this.hasVisibleEmbeddedMenuBar(jMenuBar);
            boolean bl2 = bl && this.hasLeadingMenus(jMenuBar);
            boolean bl3 = FlatTitlePane.this.getComponentOrientation().isLeftToRight();
            if (bl) {
                Component component;
                n = UIScale.scale(FlatTitlePane.this.menuBarTitleMinimumGap);
                if (bl2) {
                    if (bl3) {
                        rectangle.x += n;
                    }
                    rectangle.width -= n;
                }
                if ((component = FlatTitlePane.this.findHorizontalGlue(jMenuBar)) != null && jMenuBar.getComponent(jMenuBar.getComponentCount() - 1) != component) {
                    if (!bl3) {
                        rectangle.x += n;
                    }
                    rectangle.width -= n;
                }
            }
            n = 0;
            int n2 = 0;
            if (icon != null) {
                object = FlatTitlePane.this.iconLabel.getInsets();
                n = bl3 ? ((Insets)object).right : ((Insets)object).left;
                n2 = icon.getIconWidth() + n;
            }
            if (!((String)(object = SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, n))).equals(string)) {
                rectangle3.x = bl3 ? rectangle.x + n2 : rectangle.x + rectangle.width - n2 - rectangle3.width;
            } else {
                boolean bl4;
                int n3 = bl2 ? UIScale.scale(FlatTitlePane.this.menuBarTitleGap - FlatTitlePane.this.menuBarTitleMinimumGap) : 0;
                boolean bl5 = bl4 = bl2 ? FlatTitlePane.this.centerTitleIfMenuBarEmbedded : FlatTitlePane.this.centerTitle;
                if (bl4) {
                    Container container = jLabel.getParent();
                    int n4 = container != null ? (container.getWidth() - rectangle3.width - n2) / 2 + n2 - jLabel.getX() : -1;
                    rectangle3.x = n4 >= rectangle.x + n3 && n4 + rectangle3.width <= rectangle.x + rectangle.width - n3 ? n4 : rectangle.x + (rectangle.width - rectangle3.width - n2) / 2 + n2;
                } else {
                    int n5 = rectangle3.x = bl3 ? Math.min(rectangle.x + n3 + n2, rectangle.x + rectangle.width - rectangle3.width) : Math.max(rectangle.x + rectangle.width - n3 - n2 - rectangle3.width, rectangle.x);
                }
            }
            if (icon != null) {
                rectangle2.x = bl3 ? rectangle3.x - n2 : rectangle3.x + rectangle3.width + n;
            }
            return object;
        }

        private boolean hasLeadingMenus(JMenuBar jMenuBar) {
            boolean bl;
            if (jMenuBar.getComponentCount() == 0 || jMenuBar.getWidth() == 0) {
                return false;
            }
            Component component = FlatTitlePane.this.findHorizontalGlue(jMenuBar);
            return component == null || (!(bl = FlatTitlePane.this.getComponentOrientation().isLeftToRight()) || component.getX() != 0) && (bl || component.getX() + component.getWidth() != jMenuBar.getWidth());
        }
    }

    protected class FlatTitlePaneBorder
    extends AbstractBorder {
        protected FlatTitlePaneBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            super.getBorderInsets(component, insets);
            Border border = this.getMenuBarBorder();
            if (border != null) {
                Insets insets2 = border.getBorderInsets(component);
                insets.bottom += insets2.bottom;
            } else if (!(FlatTitlePane.this.borderColor == null || FlatTitlePane.this.rootPane.getJMenuBar() != null && FlatTitlePane.this.rootPane.getJMenuBar().isVisible())) {
                insets.bottom += UIScale.scale(1);
            }
            if (FlatTitlePane.this.isWindowTopBorderNeeded() && !FlatTitlePane.this.isWindowMaximized()) {
                insets = FlatUIUtils.addInsets(insets, FlatNativeWindowBorder.WindowTopBorder.getInstance().getBorderInsets());
            }
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Border border = this.getMenuBarBorder();
            if (border != null) {
                border.paintBorder(FlatTitlePane.this.rootPane.getJMenuBar(), graphics, n, n2, n3, n4);
            } else if (!(FlatTitlePane.this.borderColor == null || FlatTitlePane.this.rootPane.getJMenuBar() != null && FlatTitlePane.this.rootPane.getJMenuBar().isVisible())) {
                float f = UIScale.scale(1.0f);
                FlatUIUtils.paintFilledRectangle(graphics, FlatTitlePane.this.borderColor, n, (float)(n2 + n4) - f, n3, f);
            }
            if (FlatTitlePane.this.isWindowTopBorderNeeded() && !FlatTitlePane.this.isWindowMaximized() && !FlatTitlePane.this.isFullWindowContent()) {
                FlatNativeWindowBorder.WindowTopBorder.getInstance().paintBorder(component, graphics, n, n2, n3, n4);
            }
        }

        protected Border getMenuBarBorder() {
            JMenuBar jMenuBar = FlatTitlePane.this.rootPane.getJMenuBar();
            return FlatTitlePane.this.hasVisibleEmbeddedMenuBar(jMenuBar) ? jMenuBar.getBorder() : null;
        }
    }
}

