/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.FlatSystemProperties;
import java.util.ArrayList;
import javax.swing.Timer;

public class Animator {
    private int duration;
    private int resolution = 10;
    private Interpolator interpolator;
    private final ArrayList<TimingTarget> targets = new ArrayList();
    private final Runnable endRunnable;
    private boolean running;
    private boolean hasBegun;
    private boolean timeToStop;
    private long startTime;
    private Timer timer;

    public static boolean useAnimation() {
        return FlatSystemProperties.getBoolean("flatlaf.animation", true);
    }

    public Animator(int n) {
        this(n, null, null);
    }

    public Animator(int n, TimingTarget timingTarget) {
        this(n, timingTarget, null);
    }

    public Animator(int n, TimingTarget timingTarget, Runnable runnable) {
        this.setDuration(n);
        this.addTarget(timingTarget);
        this.endRunnable = runnable;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int n) {
        this.throwExceptionIfRunning();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.duration = n;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int n) {
        this.throwExceptionIfRunning();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.resolution = n;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.throwExceptionIfRunning();
        this.interpolator = interpolator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTarget(TimingTarget timingTarget) {
        if (timingTarget == null) {
            return;
        }
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            if (!this.targets.contains(timingTarget)) {
                this.targets.add(timingTarget);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTarget(TimingTarget timingTarget) {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            this.targets.remove(timingTarget);
        }
    }

    public void start() {
        this.throwExceptionIfRunning();
        this.running = true;
        this.hasBegun = false;
        this.timeToStop = false;
        this.startTime = System.nanoTime() / 1000000L;
        if (this.timer == null) {
            this.timer = new Timer(this.resolution, actionEvent -> {
                if (!this.hasBegun) {
                    this.begin();
                    this.hasBegun = true;
                }
                this.timingEvent(this.getTimingFraction());
            });
        } else {
            this.timer.setDelay(this.resolution);
        }
        this.timer.setInitialDelay(0);
        this.timer.start();
    }

    public void stop() {
        this.stop(false);
    }

    public void cancel() {
        this.stop(true);
    }

    private void stop(boolean bl) {
        if (!this.running) {
            return;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        if (!bl) {
            this.end();
        }
        this.running = false;
        this.timeToStop = false;
    }

    public void restart() {
        this.cancel();
        this.start();
    }

    public boolean isRunning() {
        return this.running;
    }

    private float getTimingFraction() {
        long l = System.nanoTime() / 1000000L;
        long l2 = l - this.startTime;
        this.timeToStop = l2 >= (long)this.duration;
        float f = this.clampFraction((float)l2 / (float)this.duration);
        if (this.interpolator != null) {
            f = this.clampFraction(this.interpolator.interpolate(f));
        }
        return f;
    }

    private float clampFraction(float f) {
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timingEvent(float f) {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (TimingTarget timingTarget : this.targets) {
                timingTarget.timingEvent(f);
            }
        }
        if (this.timeToStop) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void begin() {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (TimingTarget timingTarget : this.targets) {
                timingTarget.begin();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end() {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (TimingTarget timingTarget : this.targets) {
                timingTarget.end();
            }
        }
        if (this.endRunnable != null) {
            this.endRunnable.run();
        }
    }

    private void throwExceptionIfRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
    }

    @FunctionalInterface
    public static interface Interpolator {
        public float interpolate(float var1);
    }

    @FunctionalInterface
    public static interface TimingTarget {
        public void timingEvent(float var1);

        default public void begin() {
        }

        default public void end() {
        }
    }
}

