/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.Animator;

public class CubicBezierEasing
implements Animator.Interpolator {
    public static final CubicBezierEasing STANDARD_EASING = new CubicBezierEasing(0.4f, 0.0f, 0.2f, 1.0f);
    public static final CubicBezierEasing EASE = new CubicBezierEasing(0.25f, 0.1f, 0.25f, 1.0f);
    public static final CubicBezierEasing EASE_IN = new CubicBezierEasing(0.42f, 0.0f, 1.0f, 1.0f);
    public static final CubicBezierEasing EASE_IN_OUT = new CubicBezierEasing(0.42f, 0.0f, 0.58f, 1.0f);
    public static final CubicBezierEasing EASE_OUT = new CubicBezierEasing(0.0f, 0.0f, 0.58f, 1.0f);
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;

    public CubicBezierEasing(float f, float f2, float f3, float f4) {
        if (f < 0.0f || f > 1.0f || f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f || f4 < 0.0f || f4 > 1.0f) {
            throw new IllegalArgumentException("control points must be in range [0, 1]");
        }
        this.x1 = f;
        this.y1 = f2;
        this.x2 = f3;
        this.y2 = f4;
    }

    @Override
    public float interpolate(float f) {
        if (f <= 0.0f || f >= 1.0f) {
            return f;
        }
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f4;
        float f5;
        while (!(Math.abs(f - (f5 = CubicBezierEasing.cubicBezier(f4 = (f2 + f3) / 2.0f, this.x1, this.x2))) < 5.0E-4f)) {
            if (f5 < f) {
                f2 = f4;
                continue;
            }
            f3 = f4;
        }
        return CubicBezierEasing.cubicBezier(f4, this.y1, this.y2);
    }

    private static float cubicBezier(float f, float f2, float f3) {
        float f4 = 1.0f - f;
        float f5 = 3.0f * f * (f4 * f4);
        float f6 = 3.0f * (f * f) * f4;
        float f7 = f * f * f;
        return f5 * f2 + f6 * f3 + f7;
    }
}

