/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.server.plugins.OriginConnectionPointKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B1\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0014J@\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001a\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b!\u0010\u0014R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010 \u001a\u0004\b\"\u0010\u0014R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010 \u001a\u0004\b#\u0010\u0014\u00a8\u0006%"}, d2={"Lio/ktor/server/routing/HostRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "", "", "hostList", "Lkotlin/text/Regex;", "hostPatterns", "", "portsList", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "Lio/ktor/server/routing/RoutingResolveContext;", "context", "segmentIndex", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "evaluate", "(Lio/ktor/server/routing/RoutingResolveContext;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "()Ljava/lang/String;", "component1", "()Ljava/util/List;", "component2", "component3", "copy", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)Lio/ktor/server/routing/HostRouteSelector;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Ljava/util/List;", "getHostList", "getHostPatterns", "getPortsList", "Companion", "ktor-server-core"})
public final class HostRouteSelector
extends RouteSelector {
    public static final Companion Companion = new Companion(null);
    private final List<String> hostList;
    private final List<Regex> hostPatterns;
    private final List<Integer> portsList;
    public static final String HostNameParameter = "$RequestHost";
    public static final String PortParameter = "$RequestPort";

    public HostRouteSelector(List<String> list, List<Regex> list2, List<Integer> list3) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter(list2, (String)"");
        Intrinsics.checkNotNullParameter(list3, (String)"");
        this.hostList = list;
        this.hostPatterns = list2;
        this.portsList = list3;
        if (!(!((Collection)this.hostList).isEmpty() || !((Collection)this.hostPatterns).isEmpty() || !((Collection)this.portsList).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final List<String> getHostList() {
        return this.hostList;
    }

    public final List<Regex> getHostPatterns() {
        return this.hostPatterns;
    }

    public final List<Integer> getPortsList() {
        return this.portsList;
    }

    @Override
    public Object evaluate(RoutingResolveContext routingResolveContext, int n, Continuation<? super RouteSelectorEvaluation> continuation) {
        ParametersBuilder parametersBuilder;
        String string = OriginConnectionPointKt.getOrigin(routingResolveContext.getCall().getRequest()).getServerHost();
        int n2 = OriginConnectionPointKt.getOrigin(routingResolveContext.getCall().getRequest()).getServerPort();
        if (!((Collection)this.hostList).isEmpty() || !((Collection)this.hostPatterns).isEmpty()) {
            boolean bl;
            boolean bl2;
            block8: {
                boolean bl3;
                bl2 = this.hostList.contains(string);
                if (!bl2) {
                    Iterable iterable = this.hostPatterns;
                    boolean bl4 = false;
                    if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object t : iterable) {
                            Regex regex = (Regex)t;
                            boolean bl5 = false;
                            if (!regex.matches((CharSequence)string)) continue;
                            bl3 = true;
                            break block8;
                        }
                        bl3 = false;
                    }
                } else {
                    bl3 = bl = false;
                }
            }
            if (!bl2 && !bl) {
                return RouteSelectorEvaluation.Companion.getFailed();
            }
        }
        if (!((Collection)this.portsList).isEmpty() && !this.portsList.contains(Boxing.boxInt((int)n2))) {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        Parameters.Companion companion = Parameters.Companion;
        boolean bl = false;
        ParametersBuilder parametersBuilder2 = parametersBuilder = ParametersKt.ParametersBuilder$default((int)0, (int)1, null);
        boolean bl6 = false;
        parametersBuilder2.append(HostNameParameter, string);
        parametersBuilder2.append(PortParameter, String.valueOf(n2));
        Parameters parameters = parametersBuilder.build();
        return new RouteSelectorEvaluation.Success(1.0, parameters, 0, 4, null);
    }

    public String toString() {
        return "" + '(' + this.hostList + ", " + this.hostPatterns + ", " + this.portsList + ')';
    }

    public final List<String> component1() {
        return this.hostList;
    }

    public final List<Regex> component2() {
        return this.hostPatterns;
    }

    public final List<Integer> component3() {
        return this.portsList;
    }

    public final HostRouteSelector copy(List<String> list, List<Regex> list2, List<Integer> list3) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter(list2, (String)"");
        Intrinsics.checkNotNullParameter(list3, (String)"");
        return new HostRouteSelector(list, list2, list3);
    }

    public static /* synthetic */ HostRouteSelector copy$default(HostRouteSelector hostRouteSelector, List list, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = hostRouteSelector.hostList;
        }
        if ((n & 2) != 0) {
            list2 = hostRouteSelector.hostPatterns;
        }
        if ((n & 4) != 0) {
            list3 = hostRouteSelector.portsList;
        }
        return hostRouteSelector.copy(list, list2, list3);
    }

    public int hashCode() {
        int n = ((Object)this.hostList).hashCode();
        n = n * 31 + ((Object)this.hostPatterns).hashCode();
        n = n * 31 + ((Object)this.portsList).hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HostRouteSelector)) {
            return false;
        }
        HostRouteSelector hostRouteSelector = (HostRouteSelector)object;
        if (!Intrinsics.areEqual(this.hostList, hostRouteSelector.hostList)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.hostPatterns, hostRouteSelector.hostPatterns)) {
            return false;
        }
        return Intrinsics.areEqual(this.portsList, hostRouteSelector.portsList);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lio/ktor/server/routing/HostRouteSelector$Companion;", "", "<init>", "()V", "", "HostNameParameter", "Ljava/lang/String;", "PortParameter", "ktor-server-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

