/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.compress.provider;

import java.util.logging.Logger;
import org.jivesoftware.smack.compress.packet.Failure;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.NonzaProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;

public final class FailureProvider
extends NonzaProvider<Failure> {
    private static final Logger LOGGER = Logger.getLogger(FailureProvider.class.getName());
    public static final FailureProvider INSTANCE = new FailureProvider();

    private FailureProvider() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Failure parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
        Failure.CompressFailureError compressFailureError = null;
        StanzaError stanzaError = null;
        XmlEnvironment xmlEnvironment2 = XmlEnvironment.from(xmlPullParser, xmlEnvironment);
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string;
                    String string2 = xmlPullParser.getName();
                    block9 : switch (string = xmlPullParser.getNamespace()) {
                        case "http://jabber.org/protocol/compress": {
                            compressFailureError = Failure.CompressFailureError.valueOf(string2.replace("-", "_"));
                            if (compressFailureError == null) {
                                LOGGER.warning("Unknown element in http://jabber.org/protocol/compress: " + string2);
                                break;
                            }
                            break block0;
                        }
                        case "jabber:client": 
                        case "jabber:server": {
                            switch (string2) {
                                case "error": {
                                    stanzaError = PacketParserUtils.parseError(xmlPullParser, xmlEnvironment2);
                                    break block9;
                                }
                            }
                            LOGGER.warning("Unknown element in " + string + ": " + string2);
                            break;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    return new Failure(compressFailureError, stanzaError);
                }
            }
        }
    }
}

