/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.debugger;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;

public final class ReflectionDebuggerFactory
implements SmackDebuggerFactory {
    private static final Logger LOGGER = Logger.getLogger(ReflectionDebuggerFactory.class.getName());
    private static final String DEBUGGER_CLASS_PROPERTY_NAME = "smack.debuggerClass";
    public static final ReflectionDebuggerFactory INSTANCE = new ReflectionDebuggerFactory();
    private static final String[] DEFAULT_DEBUGGERS = new String[]{"org.jivesoftware.smackx.debugger.EnhancedDebugger", "org.jivesoftware.smackx.debugger.android.AndroidDebugger", "org.jivesoftware.smack.debugger.ConsoleDebugger", "org.jivesoftware.smack.debugger.LiteDebugger", "org.jivesoftware.smack.debugger.JulDebugger"};

    private ReflectionDebuggerFactory() {
    }

    public static void setDebuggerClass(Class<? extends SmackDebugger> clazz) {
        if (clazz == null) {
            System.clearProperty(DEBUGGER_CLASS_PROPERTY_NAME);
        } else {
            System.setProperty(DEBUGGER_CLASS_PROPERTY_NAME, clazz.getCanonicalName());
        }
    }

    public static Class<SmackDebugger> getDebuggerClass() {
        String string = ReflectionDebuggerFactory.getCustomDebuggerClassName();
        if (string == null) {
            return ReflectionDebuggerFactory.getOneOfDefaultDebuggerClasses();
        }
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Unable to instantiate debugger class " + string, exception);
            return null;
        }
    }

    @Override
    public SmackDebugger create(XMPPConnection xMPPConnection) {
        Class<SmackDebugger> clazz = ReflectionDebuggerFactory.getDebuggerClass();
        if (clazz != null) {
            try {
                Constructor<SmackDebugger> constructor = clazz.getConstructor(XMPPConnection.class);
                return constructor.newInstance(xMPPConnection);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Can't initialize the configured debugger!", exception);
            }
        }
        return null;
    }

    private static String getCustomDebuggerClassName() {
        try {
            return System.getProperty(DEBUGGER_CLASS_PROPERTY_NAME);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class<SmackDebugger> getOneOfDefaultDebuggerClasses() {
        for (String string : DEFAULT_DEBUGGERS) {
            if (SmackConfiguration.isDisabledSmackClass(string)) continue;
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.fine("Did not find debugger class '" + string + "'");
            }
            catch (ClassCastException classCastException) {
                LOGGER.warning("Found debugger class that does not appears to implement SmackDebugger interface");
            }
            catch (Exception exception) {
                LOGGER.warning("Unable to instantiate either Smack debugger class");
            }
        }
        return null;
    }
}

