/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;

public abstract class AbstractListFilter
implements StanzaFilter {
    protected final List<StanzaFilter> filters;

    protected AbstractListFilter() {
        this.filters = new ArrayList<StanzaFilter>();
    }

    protected AbstractListFilter(StanzaFilter ... stanzaFilterArray) {
        this(new ArrayList<StanzaFilter>(Arrays.asList(stanzaFilterArray)));
    }

    protected AbstractListFilter(List<StanzaFilter> list) {
        Objects.requireNonNull(list, "Parameter must not be null.");
        for (StanzaFilter stanzaFilter : list) {
            Objects.requireNonNull(stanzaFilter, "Parameter must not be null.");
        }
        this.filters = list;
    }

    public void addFilter(StanzaFilter stanzaFilter) {
        Objects.requireNonNull(stanzaFilter, "Parameter must not be null.");
        this.filters.add(stanzaFilter);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(": (");
        stringBuilder.append((CharSequence)StringUtils.toStringBuilder(this.filters, ", "));
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

