/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.e.a.i;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XmlLangElement;
import org.jivesoftware.smack.packet.id.StandardStanzaIdSource;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.PacketUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.XmppElementUtil;

public abstract class Stanza
implements StanzaView,
TopLevelStreamElement {
    public static final String TEXT = "text";
    public static final String ITEM = "item";
    protected static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage().toLowerCase(Locale.US);
    private final MultiMap<QName, ExtensionElement> extensionElements;
    private final String namespace = "jabber:client";
    private final StanzaIdSource usedStanzaIdSource;
    private String id = null;
    private i to;
    private i from;
    private StanzaError error = null;
    protected String language;

    protected Stanza() {
        this.extensionElements = new MultiMap();
        this.usedStanzaIdSource = null;
        this.id = StandardStanzaIdSource.DEFAULT.getNewStanzaId();
    }

    protected Stanza(StanzaBuilder<?> stanzaBuilder) {
        if (stanzaBuilder.stanzaIdSource != null) {
            this.id = stanzaBuilder.stanzaIdSource.getNewStanzaId();
            assert (StringUtils.isNullOrNotEmpty(this.id));
            this.usedStanzaIdSource = stanzaBuilder.stanzaIdSource;
        } else {
            this.id = stanzaBuilder.stanzaId;
            this.usedStanzaIdSource = null;
        }
        this.to = stanzaBuilder.to;
        this.from = stanzaBuilder.from;
        this.error = stanzaBuilder.stanzaError;
        this.language = stanzaBuilder.language;
        this.extensionElements = stanzaBuilder.extensionElements.clone();
    }

    protected Stanza(Stanza stanza) {
        this.usedStanzaIdSource = stanza.usedStanzaIdSource;
        this.id = stanza.getStanzaId();
        this.to = stanza.getTo();
        this.from = stanza.getFrom();
        this.error = stanza.error;
        this.extensionElements = stanza.extensionElements.clone();
    }

    @Override
    public final String getStanzaId() {
        return this.id;
    }

    public void setStanzaId(String string) {
        if (string != null) {
            StringUtils.requireNotNullNorEmpty(string, "id must either be null or not the empty String");
        }
        this.id = string;
    }

    public final boolean hasStanzaIdSet() {
        return this.id != null;
    }

    @Deprecated
    public String setStanzaId() {
        if (!this.hasStanzaIdSet()) {
            this.setNewStanzaId();
        }
        return this.getStanzaId();
    }

    public final void throwIfNoStanzaId() {
        if (this.hasStanzaIdSet()) {
            return;
        }
        throw new IllegalArgumentException("The stanza has no RFC stanza ID set, although one is required");
    }

    protected String setNewStanzaId() {
        this.id = this.usedStanzaIdSource != null ? this.usedStanzaIdSource.getNewStanzaId() : StandardStanzaIdSource.DEFAULT.getNewStanzaId();
        return this.getStanzaId();
    }

    @Override
    public final i getTo() {
        return this.to;
    }

    public void setTo(i i2) {
        this.to = i2;
    }

    @Override
    public final i getFrom() {
        return this.from;
    }

    public void setFrom(i i2) {
        this.from = i2;
    }

    @Override
    public final StanzaError getError() {
        return this.error;
    }

    public void setError(StanzaError stanzaError) {
        this.error = stanzaError;
    }

    @Deprecated
    public void setError(StanzaError.Builder builder) {
        this.setError(builder.build());
    }

    @Override
    public final String getLanguage() {
        return this.language;
    }

    @Deprecated
    public void setLanguage(String string) {
        this.language = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<ExtensionElement> getExtensions() {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.values();
        }
    }

    public final MultiMap<QName, ExtensionElement> getExtensionsMap() {
        return this.cloneExtensionsMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final MultiMap<QName, ExtensionElement> cloneExtensionsMap() {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.clone();
        }
    }

    public final List<ExtensionElement> getExtensions(String string, String string2) {
        StringUtils.requireNotNullNorEmpty(string, "elementName must not be null nor empty");
        StringUtils.requireNotNullNorEmpty(string2, "namespace must not be null nor empty");
        QName qName = new QName(string2, string);
        return this.getExtensions(qName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<ExtensionElement> getExtensions(QName qName) {
        List<ExtensionElement> list;
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            list = this.extensionElements.getAll(qName);
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <E extends ExtensionElement> List<E> getExtensions(Class<E> clazz) {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return XmppElementUtil.getElementsFrom(this.extensionElements, clazz);
        }
    }

    public final ExtensionElement getExtension(String string) {
        return PacketUtil.extensionElementFrom(this.getExtensions(), null, string);
    }

    public final ExtensionElement getExtensionElement(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        QName qName = new QName(string2, string);
        ExtensionElement extensionElement = this.getExtension(qName);
        if (extensionElement == null) {
            return null;
        }
        return extensionElement;
    }

    @Deprecated
    public final <E extends ExtensionElement> E getExtension(String string, String string2) {
        return (E)this.getExtensionElement(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ExtensionElement getExtension(QName qName) {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.getFirst(qName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExtension(ExtensionElement extensionElement) {
        if (extensionElement == null) {
            return;
        }
        QName qName = extensionElement.getQName();
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            this.extensionElements.put(qName, extensionElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExtensionElement overrideExtension(ExtensionElement extensionElement) {
        if (extensionElement == null) {
            return null;
        }
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            ExtensionElement extensionElement2 = this.removeExtension(extensionElement.getElementName(), extensionElement.getNamespace());
            this.addExtension(extensionElement);
            return extensionElement2;
        }
    }

    public final void addExtensions(Collection<? extends ExtensionElement> collection) {
        if (collection == null) {
            return;
        }
        for (ExtensionElement extensionElement : collection) {
            this.addExtension(extensionElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasExtension(String string, String string2) {
        if (string == null) {
            return this.hasExtension(string2);
        }
        QName qName = new QName(string2, string);
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.containsKey(qName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasExtension(String string) {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            for (ExtensionElement extensionElement : this.extensionElements.values()) {
                if (!extensionElement.getNamespace().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExtensionElement removeExtension(String string, String string2) {
        QName qName = new QName(string2, string);
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.remove(qName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final ExtensionElement removeExtension(ExtensionElement extensionElement) {
        QName qName = extensionElement.getQName();
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            List<ExtensionElement> list = this.extensionElements.getAll(qName);
            boolean bl = list.remove(extensionElement);
            if (bl) {
                return extensionElement;
            }
        }
        return null;
    }

    public abstract String toString();

    @Override
    public final String getNamespace() {
        return "jabber:client";
    }

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    protected final void addCommonAttributes(XmlStringBuilder xmlStringBuilder) {
        xmlStringBuilder.optAttribute("to", (CharSequence)this.getTo());
        xmlStringBuilder.optAttribute("from", (CharSequence)this.getFrom());
        xmlStringBuilder.optAttribute("id", this.getStanzaId());
    }

    protected void logCommonAttributes(StringBuilder stringBuilder) {
        if (this.getTo() != null) {
            stringBuilder.append("to=").append((CharSequence)this.to).append(',');
        }
        if (this.getFrom() != null) {
            stringBuilder.append("from=").append((CharSequence)this.from).append(',');
        }
        if (this.hasStanzaIdSet()) {
            stringBuilder.append("id=").append(this.id).append(',');
        }
    }

    protected final void appendErrorIfExists(XmlStringBuilder xmlStringBuilder) {
        StanzaError stanzaError = this.getError();
        if (stanzaError != null) {
            xmlStringBuilder.append(stanzaError);
        }
    }

    static String determineLanguage(XmlLangElement xmlLangElement, String string) {
        if (string != null && !string.isEmpty()) {
            return string;
        }
        return xmlLangElement.getLanguage();
    }
}

