/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());

    public static InputStream getInputStreamForClasspathFile(String string) {
        return FileUtils.getInputStreamForClasspathFile(string, null);
    }

    public static InputStream getInputStreamForClasspathFile(String string, ClassLoader classLoader) {
        try {
            return FileUtils.getStreamForClasspathFile(string, classLoader);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Suppressed IOException in getInputStreamForClasspathFile", iOException);
            return null;
        }
    }

    public static InputStream getStreamForClasspathFile(String string, ClassLoader classLoader) {
        List<ClassLoader> list = FileUtils.getClassLoaders();
        if (classLoader != null) {
            list.add(0, classLoader);
        }
        for (ClassLoader classLoader2 : list) {
            InputStream inputStream = classLoader2.getResourceAsStream(string);
            if (inputStream == null) continue;
            return inputStream;
        }
        throw new IOException("Unable to get '" + string + "' from classpath. Tried ClassLoaders:" + list);
    }

    public static InputStream getStreamForUri(URI uRI, ClassLoader classLoader) {
        String string = uRI.getScheme();
        if (string.equals("classpath")) {
            String string2 = uRI.getSchemeSpecificPart();
            return FileUtils.getStreamForClasspathFile(string2, classLoader);
        }
        URL uRL = uRI.toURL();
        return uRL.openStream();
    }

    public static List<ClassLoader> getClassLoaders() {
        ClassLoader[] classLoaderArray = new ClassLoader[]{FileUtils.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(classLoaderArray.length);
        for (ClassLoader classLoader : classLoaderArray) {
            if (classLoader == null) continue;
            arrayList.add(classLoader);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addLines(String string, Set<String> set) {
        URI uRI = URI.create(string);
        InputStream inputStream = FileUtils.getStreamForUri(uRI, null);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                set.add(string2);
            }
        }
        return true;
    }

    public static String readFileOrThrow(File file) {
        try (FileReader fileReader = new FileReader(file);){
            int n;
            char[] cArray = new char[8192];
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = fileReader.read(cArray)) >= 0) {
                stringBuilder.append(cArray, 0, n);
            }
            String string = stringBuilder.toString();
            return string;
        }
    }

    public static String readFile(File file) {
        try {
            return FileUtils.readFileOrThrow(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.FINE, "readFile", fileNotFoundException);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "readFile", iOException);
        }
        return null;
    }

    public static void writeFileOrThrow(File file, CharSequence charSequence) {
        try (FileWriter fileWriter = new FileWriter(file, false);){
            fileWriter.write(charSequence.toString());
        }
    }

    public static boolean writeFile(File file, CharSequence charSequence) {
        try {
            FileUtils.writeFileOrThrow(file, charSequence);
            return true;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "writeFile", iOException);
            return false;
        }
    }

    public static FileOutputStream prepareFileOutputStream(File file) {
        if (!file.exists()) {
            File file2 = file.getParentFile();
            if (!file2.exists() && !file2.mkdirs()) {
                throw new IOException("Cannot create directory " + file2.getAbsolutePath());
            }
            if (!file.createNewFile()) {
                throw new IOException("Cannot create file " + file.getAbsolutePath());
            }
        }
        if (file.isDirectory()) {
            throw new AssertionError((Object)("File " + file.getAbsolutePath() + " is not a file!"));
        }
        return new FileOutputStream(file);
    }

    public static FileInputStream prepareFileInputStream(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                return new FileInputStream(file);
            }
            throw new IOException("File " + file.getAbsolutePath() + " is not a file!");
        }
        throw new FileNotFoundException("File " + file.getAbsolutePath() + " not found.");
    }

    public static void maybeDeleteFileOrThrow(File file) {
        if (!file.exists()) {
            return;
        }
        boolean bl = file.delete();
        if (!bl) {
            throw new IOException("Could not delete file " + file);
        }
    }

    public static void maybeCreateFileWithParentDirectories(File file) {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Cannot create directory " + file2);
        }
        if (file.isFile()) {
            return;
        }
        if (!file.exists()) {
            if (file.createNewFile()) {
                return;
            }
            throw new IOException("Cannot create file " + file);
        }
        if (file.isDirectory()) {
            throw new IOException("File " + file + " exists, but is a directory.");
        }
        throw new IOException("File " + file + " exists, but is neither a file nor a directory");
    }
}

