/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.CryptoKt;
import io.ktor.util.NonceManager;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0004\b\n\u0010\u000bB5\b\u0016\u0012\u0006\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0004\b\n\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lio/ktor/util/StatelessHmacNonceManager;", "Lio/ktor/util/NonceManager;", "Ljavax/crypto/spec/SecretKeySpec;", "keySpec", "", "algorithm", "", "timeoutMillis", "Lkotlin/Function0;", "nonceGenerator", "<init>", "(Ljavax/crypto/spec/SecretKeySpec;Ljava/lang/String;JLkotlin/jvm/functions/Function0;)V", "", "key", "([BLjava/lang/String;JLkotlin/jvm/functions/Function0;)V", "newNonce", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nonce", "", "verifyNonce", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Ljavax/crypto/spec/SecretKeySpec;", "getKeySpec", "()Ljavax/crypto/spec/SecretKeySpec;", "Ljava/lang/String;", "getAlgorithm", "()Ljava/lang/String;", "J", "getTimeoutMillis", "()J", "Lkotlin/jvm/functions/Function0;", "getNonceGenerator", "()Lkotlin/jvm/functions/Function0;", "", "macLength", "I", "ktor-utils"})
public final class StatelessHmacNonceManager
implements NonceManager {
    private final SecretKeySpec keySpec;
    private final String algorithm;
    private final long timeoutMillis;
    private final Function0<String> nonceGenerator;
    private final int macLength;

    public StatelessHmacNonceManager(SecretKeySpec secretKeySpec, String string, long l, Function0<String> function0) {
        Intrinsics.checkNotNullParameter((Object)secretKeySpec, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(function0, (String)"");
        this.keySpec = secretKeySpec;
        this.algorithm = string;
        this.timeoutMillis = l;
        this.nonceGenerator = function0;
        Mac mac = Mac.getInstance(this.algorithm);
        StatelessHmacNonceManager statelessHmacNonceManager = this;
        boolean bl = false;
        mac.init(this.keySpec);
        int n = mac.getMacLength();
        statelessHmacNonceManager.macLength = n;
    }

    public /* synthetic */ StatelessHmacNonceManager(SecretKeySpec secretKeySpec, String string, long l, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "HmacSHA256";
        }
        if ((n & 4) != 0) {
            l = 60000L;
        }
        if ((n & 8) != 0) {
            function0 = StatelessHmacNonceManager::_init_$lambda$0;
        }
        this(secretKeySpec, string, l, (Function0<String>)function0);
    }

    public final SecretKeySpec getKeySpec() {
        return this.keySpec;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public final Function0<String> getNonceGenerator() {
        return this.nonceGenerator;
    }

    public StatelessHmacNonceManager(byte[] byArray, String string, long l, Function0<String> function0) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(function0, (String)"");
        this(new SecretKeySpec(byArray, string), string, l, function0);
    }

    public /* synthetic */ StatelessHmacNonceManager(byte[] byArray, String string, long l, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "HmacSHA256";
        }
        if ((n & 4) != 0) {
            l = 60000L;
        }
        if ((n & 8) != 0) {
            function0 = StatelessHmacNonceManager::_init_$lambda$1;
        }
        this(byArray, string, l, (Function0<String>)function0);
    }

    @Override
    public Object newNonce(Continuation<? super String> continuation2) {
        Mac mac;
        String string = (String)this.nonceGenerator.invoke();
        String string2 = Long.toString(System.nanoTime(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        String string3 = StringsKt.padStart((String)string2, (int)16, (char)'0');
        Mac mac2 = mac = Mac.getInstance(this.algorithm);
        boolean bl = false;
        mac2.init(this.keySpec);
        byte[] byArray = (string + ':' + string3).getBytes(Charsets.ISO_8859_1);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
        mac2.update(byArray);
        byte[] byArray2 = mac.doFinal();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"");
        String string4 = CryptoKt.hex(byArray2);
        return string + '+' + string3 + '+' + string4;
    }

    @Override
    public Object verifyNonce(String string, Continuation<? super Boolean> continuation2) {
        Mac mac;
        Object object = new char[]{'+'};
        List list = StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)0, (int)6, null);
        if (list.size() != 3) {
            return Boxing.boxBoolean((boolean)false);
        }
        object = (String)list.get(0);
        String string2 = (String)list.get(1);
        String string3 = (String)list.get(2);
        if (object.length() < 8) {
            return Boxing.boxBoolean((boolean)false);
        }
        if (string3.length() != this.macLength * 2) {
            return Boxing.boxBoolean((boolean)false);
        }
        if (string2.length() != 16) {
            return Boxing.boxBoolean((boolean)false);
        }
        long l = Long.parseLong(string2, CharsKt.checkRadix((int)16));
        if (l + TimeUnit.MILLISECONDS.toNanos(this.timeoutMillis) < System.nanoTime()) {
            return Boxing.boxBoolean((boolean)false);
        }
        Mac mac2 = mac = Mac.getInstance(this.algorithm);
        boolean bl = false;
        mac2.init(this.keySpec);
        byte[] byArray = ((String)object + ':' + string2).getBytes(Charsets.ISO_8859_1);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
        mac2.update(byArray);
        byte[] byArray2 = mac.doFinal();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"");
        String string4 = CryptoKt.hex(byArray2);
        int n = 0;
        int n2 = Math.min(string4.length(), string3.length());
        for (int k = 0; k < n2; ++k) {
            if (string4.charAt(k) != string3.charAt(k)) continue;
            ++n;
        }
        return Boxing.boxBoolean((n == this.macLength * 2 ? 1 : 0) != 0);
    }

    private static final String _init_$lambda$0() {
        return CryptoKt.generateNonce();
    }

    private static final String _init_$lambda$1() {
        return CryptoKt.generateNonce();
    }
}

