/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.pcap;

import io.netty.buffer.ByteBuf;

final class TCPPacket {
    private static final short OFFSET = 20480;

    private TCPPacket() {
    }

    static void writePacket(ByteBuf byteBuf, ByteBuf byteBuf2, long l, long l2, int n, int n2, TCPFlag ... tCPFlagArray) {
        byteBuf.writeShort(n);
        byteBuf.writeShort(n2);
        byteBuf.writeInt((int)l);
        byteBuf.writeInt((int)l2);
        byteBuf.writeShort(0x5000 | TCPFlag.getFlag(tCPFlagArray));
        byteBuf.writeShort(65535);
        byteBuf.writeShort(1);
        byteBuf.writeShort(0);
        if (byteBuf2 != null) {
            byteBuf.writeBytes(byteBuf2);
        }
    }

    static enum TCPFlag {
        FIN(1),
        SYN(2),
        RST(4),
        PSH(8),
        ACK(16),
        URG(32),
        ECE(64),
        CWR(128);

        private final int value;

        private TCPFlag(int n2) {
            this.value = n2;
        }

        static int getFlag(TCPFlag ... tCPFlagArray) {
            int n = 0;
            for (TCPFlag tCPFlag : tCPFlagArray) {
                n |= tCPFlag.value;
            }
            return n;
        }
    }
}

