/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SslClientHelloHandler;
import io.netty.handler.ssl.SslHandshakeTimeoutException;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public abstract class AbstractSniHandler<T>
extends SslClientHelloHandler<T> {
    protected final long handshakeTimeoutMillis;
    private ScheduledFuture<?> timeoutFuture;
    private String hostname;

    private static String extractSniHostname(ByteBuf byteBuf) {
        int n = byteBuf.readerIndex();
        int n2 = byteBuf.writerIndex();
        if (n2 - (n += 34) >= 6) {
            int n3;
            int n4;
            short s = byteBuf.getUnsignedByte(n);
            int n5 = byteBuf.getUnsignedShort(n += s + 1);
            short s2 = byteBuf.getUnsignedByte(n += n5 + 2);
            n += s2 + 1;
            if ((n4 = (n += 2) + (n3 = byteBuf.getUnsignedShort(n))) <= n2) {
                while (n4 - n >= 4) {
                    int n6;
                    int n7 = byteBuf.getUnsignedShort(n);
                    n += 2;
                    if (n4 - (n += 2) < (n6 = byteBuf.getUnsignedShort(n))) break;
                    if (n7 == 0) {
                        int n8;
                        if (n4 - (n += 2) < 3) break;
                        short s3 = byteBuf.getUnsignedByte(n);
                        ++n;
                        if (s3 != 0 || n4 - (n += 2) < (n8 = byteBuf.getUnsignedShort(n))) break;
                        String string = byteBuf.toString(n, n8, CharsetUtil.US_ASCII);
                        return string.toLowerCase(Locale.US);
                    }
                    n += n6;
                }
            }
        }
        return null;
    }

    protected AbstractSniHandler(long l) {
        this(0, l);
    }

    protected AbstractSniHandler(int n, long l) {
        super(n);
        this.handshakeTimeoutMillis = ObjectUtil.checkPositiveOrZero((long)l, (String)"handshakeTimeoutMillis");
    }

    public AbstractSniHandler() {
        this(0, 0L);
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isActive()) {
            this.checkStartTimeout(channelHandlerContext);
        }
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.fireChannelActive();
        this.checkStartTimeout(channelHandlerContext);
    }

    private void checkStartTimeout(final ChannelHandlerContext channelHandlerContext) {
        if (this.handshakeTimeoutMillis <= 0L || this.timeoutFuture != null) {
            return;
        }
        this.timeoutFuture = channelHandlerContext.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (channelHandlerContext.channel().isActive()) {
                    SslHandshakeTimeoutException sslHandshakeTimeoutException = new SslHandshakeTimeoutException("handshake timed out after " + AbstractSniHandler.this.handshakeTimeoutMillis + "ms");
                    channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent(sslHandshakeTimeoutException));
                    channelHandlerContext.close();
                }
            }
        }, this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    protected Future<T> lookup(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        this.hostname = byteBuf == null ? null : AbstractSniHandler.extractSniHostname(byteBuf);
        return this.lookup(channelHandlerContext, this.hostname);
    }

    @Override
    protected void onLookupComplete(ChannelHandlerContext channelHandlerContext, Future<T> future) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        try {
            this.onLookupComplete(channelHandlerContext, this.hostname, future);
        }
        finally {
            AbstractSniHandler.fireSniCompletionEvent(channelHandlerContext, this.hostname, future);
        }
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, String var2);

    protected abstract void onLookupComplete(ChannelHandlerContext var1, String var2, Future<T> var3);

    private static void fireSniCompletionEvent(ChannelHandlerContext channelHandlerContext, String string, Future<?> future) {
        Throwable throwable = future.cause();
        if (throwable == null) {
            channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent(string));
        } else {
            channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent(string, throwable));
        }
    }
}

