/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

public class ChunkedWriteHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChunkedWriteHandler.class);
    private Queue<PendingWrite> queue;
    private volatile ChannelHandlerContext ctx;

    public ChunkedWriteHandler() {
    }

    @Deprecated
    public ChunkedWriteHandler(int n) {
        ObjectUtil.checkPositive((int)n, (String)"maxPendingWrites");
    }

    private void allocateQueue() {
        if (this.queue == null) {
            this.queue = new ArrayDeque<PendingWrite>();
        }
    }

    private boolean queueIsEmpty() {
        return this.queue == null || this.queue.isEmpty();
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    public void resumeTransfer() {
        final ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            return;
        }
        if (channelHandlerContext.executor().inEventLoop()) {
            this.resumeTransfer0(channelHandlerContext);
        } else {
            channelHandlerContext.executor().execute(new Runnable(){

                @Override
                public void run() {
                    ChunkedWriteHandler.this.resumeTransfer0(channelHandlerContext);
                }
            });
        }
    }

    private void resumeTransfer0(ChannelHandlerContext channelHandlerContext) {
        try {
            this.doFlush(channelHandlerContext);
        }
        catch (Exception exception) {
            logger.warn("Unexpected exception while sending chunks.", (Throwable)exception);
        }
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (!this.queueIsEmpty() || object instanceof ChunkedInput) {
            this.allocateQueue();
            this.queue.add(new PendingWrite(object, channelPromise));
        } else {
            channelHandlerContext.write(object, channelPromise);
        }
    }

    public void flush(ChannelHandlerContext channelHandlerContext) {
        this.doFlush(channelHandlerContext);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.doFlush(channelHandlerContext);
        channelHandlerContext.fireChannelInactive();
    }

    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isWritable()) {
            this.doFlush(channelHandlerContext);
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    private void discard(Throwable throwable) {
        PendingWrite pendingWrite;
        if (this.queueIsEmpty()) {
            return;
        }
        while ((pendingWrite = this.queue.poll()) != null) {
            Object object = pendingWrite.msg;
            if (object instanceof ChunkedInput) {
                long l;
                boolean bl;
                ChunkedInput chunkedInput = (ChunkedInput)object;
                try {
                    bl = chunkedInput.isEndOfInput();
                    l = chunkedInput.length();
                    ChunkedWriteHandler.closeInput(chunkedInput);
                }
                catch (Exception exception) {
                    ChunkedWriteHandler.closeInput(chunkedInput);
                    pendingWrite.fail(exception);
                    logger.warn("ChunkedInput failed", (Throwable)exception);
                    continue;
                }
                if (!bl) {
                    if (throwable == null) {
                        throwable = new ClosedChannelException();
                    }
                    pendingWrite.fail(throwable);
                    continue;
                }
                pendingWrite.success(l);
                continue;
            }
            if (throwable == null) {
                throwable = new ClosedChannelException();
            }
            pendingWrite.fail(throwable);
        }
    }

    private void doFlush(ChannelHandlerContext channelHandlerContext) {
        PendingWrite pendingWrite;
        Channel channel = channelHandlerContext.channel();
        if (!channel.isActive()) {
            this.discard(null);
            channelHandlerContext.flush();
            return;
        }
        if (this.queueIsEmpty()) {
            channelHandlerContext.flush();
            return;
        }
        boolean bl = true;
        ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
        while (channel.isWritable() && (pendingWrite = this.queue.peek()) != null) {
            if (pendingWrite.promise.isDone()) {
                this.queue.remove();
                continue;
            }
            Object object = pendingWrite.msg;
            if (object instanceof ChunkedInput) {
                boolean bl2;
                boolean bl3;
                final ChunkedInput chunkedInput = (ChunkedInput)object;
                ByteBuf byteBuf = null;
                try {
                    byteBuf = (ByteBuf)chunkedInput.readChunk(byteBufAllocator);
                    bl3 = chunkedInput.isEndOfInput();
                    bl2 = byteBuf == null && !bl3;
                }
                catch (Throwable throwable) {
                    this.queue.remove();
                    if (byteBuf != null) {
                        ReferenceCountUtil.release(byteBuf);
                    }
                    ChunkedWriteHandler.closeInput(chunkedInput);
                    pendingWrite.fail(throwable);
                    break;
                }
                if (bl2) break;
                if (byteBuf == null) {
                    byteBuf = Unpooled.EMPTY_BUFFER;
                }
                if (bl3) {
                    this.queue.remove();
                }
                ChannelFuture channelFuture = channelHandlerContext.writeAndFlush((Object)byteBuf);
                if (bl3) {
                    if (channelFuture.isDone()) {
                        ChunkedWriteHandler.handleEndOfInputFuture(channelFuture, chunkedInput, pendingWrite);
                    } else {
                        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture channelFuture) {
                                ChunkedWriteHandler.handleEndOfInputFuture(channelFuture, chunkedInput, pendingWrite);
                            }
                        });
                    }
                } else {
                    boolean bl4;
                    boolean bl5 = bl4 = !channel.isWritable();
                    if (channelFuture.isDone()) {
                        this.handleFuture(channelFuture, chunkedInput, pendingWrite, bl4);
                    } else {
                        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture channelFuture) {
                                ChunkedWriteHandler.this.handleFuture(channelFuture, chunkedInput, pendingWrite, bl4);
                            }
                        });
                    }
                }
                bl = false;
            } else {
                this.queue.remove();
                channelHandlerContext.write(object, pendingWrite.promise);
                bl = true;
            }
            if (channel.isActive()) continue;
            this.discard(new ClosedChannelException());
            break;
        }
        if (bl) {
            channelHandlerContext.flush();
        }
    }

    private static void handleEndOfInputFuture(ChannelFuture channelFuture, ChunkedInput<?> chunkedInput, PendingWrite pendingWrite) {
        if (!channelFuture.isSuccess()) {
            ChunkedWriteHandler.closeInput(chunkedInput);
            pendingWrite.fail(channelFuture.cause());
        } else {
            long l = chunkedInput.progress();
            long l2 = chunkedInput.length();
            ChunkedWriteHandler.closeInput(chunkedInput);
            pendingWrite.progress(l, l2);
            pendingWrite.success(l2);
        }
    }

    private void handleFuture(ChannelFuture channelFuture, ChunkedInput<?> chunkedInput, PendingWrite pendingWrite, boolean bl) {
        if (!channelFuture.isSuccess()) {
            ChunkedWriteHandler.closeInput(chunkedInput);
            pendingWrite.fail(channelFuture.cause());
        } else {
            pendingWrite.progress(chunkedInput.progress(), chunkedInput.length());
            if (bl && channelFuture.channel().isWritable()) {
                this.resumeTransfer();
            }
        }
    }

    private static void closeInput(ChunkedInput<?> chunkedInput) {
        try {
            chunkedInput.close();
        }
        catch (Throwable throwable) {
            logger.warn("Failed to close a ChunkedInput.", throwable);
        }
    }

    private static final class PendingWrite {
        final Object msg;
        final ChannelPromise promise;

        PendingWrite(Object object, ChannelPromise channelPromise) {
            this.msg = object;
            this.promise = channelPromise;
        }

        void fail(Throwable throwable) {
            ReferenceCountUtil.release((Object)this.msg);
            this.promise.tryFailure(throwable);
        }

        void success(long l) {
            if (this.promise.isDone()) {
                return;
            }
            this.progress(l, l);
            this.promise.trySuccess();
        }

        void progress(long l, long l2) {
            if (this.promise instanceof ChannelProgressivePromise) {
                ((ChannelProgressivePromise)this.promise).tryProgress(l, l2);
            }
        }
    }
}

