/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.internal.InlineClassDescriptorKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonDecodingException;
import kotlinx.serialization.json.internal.JsonEncodingException;
import kotlinx.serialization.json.internal.StringJsonLexer;
import kotlinx.serialization.json.internal.StringOpsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0015\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0005\u001a\u0017\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0017\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0017\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0017\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0012\u001a\u0012\u0010\u0000\u001a\u00020\u00132\b\u0010\u0002\u001a\u0004\u0018\u00010\u0014H\u0007\u001a\u0012\u0010\u0015\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0012H\u0007\u001a\u0014\u0010N\u001a\u00020\u0014*\u00020\u001b2\u0006\u0010O\u001a\u00020\u0012H\u0002\u001a$\u0010P\u001a\u0004\u0018\u0001HQ\"\u0004\b\u0000\u0010Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u0002HQ0SH\u0082\b\u00a2\u0006\u0002\u0010T\u001a\"\u0010U\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u0002HQ0SH\u0082\b\u00a2\u0006\u0002\u0010T\u001a\u0018\u0010V\u001a\u00020\u00142\u0006\u0010W\u001a\u00020\u00122\u0006\u0010X\u001a\u00020\u0012H\u0001\u001a\f\u0010Y\u001a\u000201*\u00020\u0001H\u0000\"\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0015\u0010\u001a\u001a\u00020\u0001*\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\"\u0015\u0010\u001e\u001a\u00020\u001f*\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"\u0015\u0010\"\u001a\u00020#*\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\"\u0015\u0010&\u001a\u00020\u0013*\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\"\u0015\u0010)\u001a\u00020**\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\"\u0017\u0010-\u001a\u0004\u0018\u00010**\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\"\u0015\u00100\u001a\u000201*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\"\u0017\u00104\u001a\u0004\u0018\u000101*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b5\u00106\"\u0015\u00107\u001a\u000208*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\"\u0017\u0010;\u001a\u0004\u0018\u000108*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\"\u0015\u0010>\u001a\u00020?*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b@\u0010A\"\u0017\u0010B\u001a\u0004\u0018\u00010?*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\bC\u0010D\"\u0015\u0010E\u001a\u00020\u0003*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\"\u0017\u0010H\u001a\u0004\u0018\u00010\u0003*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\"\u0017\u0010K\u001a\u0004\u0018\u00010\u0012*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\bL\u0010M\u00a8\u0006Z"}, d2={"JsonPrimitive", "Lkotlinx/serialization/json/JsonPrimitive;", "value", "", "(Ljava/lang/Boolean;)Lkotlinx/serialization/json/JsonPrimitive;", "", "Lkotlin/UByte;", "JsonPrimitive-7apg3OU", "(B)Lkotlinx/serialization/json/JsonPrimitive;", "Lkotlin/UShort;", "JsonPrimitive-xj2QHRw", "(S)Lkotlinx/serialization/json/JsonPrimitive;", "Lkotlin/UInt;", "JsonPrimitive-WZ4Q5Ns", "(I)Lkotlinx/serialization/json/JsonPrimitive;", "Lkotlin/ULong;", "JsonPrimitive-VKZWuLQ", "(J)Lkotlinx/serialization/json/JsonPrimitive;", "", "Lkotlinx/serialization/json/JsonNull;", "", "JsonUnquotedLiteral", "jsonUnquotedLiteralDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getJsonUnquotedLiteralDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "jsonPrimitive", "Lkotlinx/serialization/json/JsonElement;", "getJsonPrimitive", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonPrimitive;", "jsonObject", "Lkotlinx/serialization/json/JsonObject;", "getJsonObject", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonObject;", "jsonArray", "Lkotlinx/serialization/json/JsonArray;", "getJsonArray", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonArray;", "jsonNull", "getJsonNull", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonNull;", "int", "", "getInt", "(Lkotlinx/serialization/json/JsonPrimitive;)I", "intOrNull", "getIntOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Integer;", "long", "", "getLong", "(Lkotlinx/serialization/json/JsonPrimitive;)J", "longOrNull", "getLongOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Long;", "double", "", "getDouble", "(Lkotlinx/serialization/json/JsonPrimitive;)D", "doubleOrNull", "getDoubleOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Double;", "float", "", "getFloat", "(Lkotlinx/serialization/json/JsonPrimitive;)F", "floatOrNull", "getFloatOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Float;", "boolean", "getBoolean", "(Lkotlinx/serialization/json/JsonPrimitive;)Z", "booleanOrNull", "getBooleanOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Boolean;", "contentOrNull", "getContentOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/String;", "error", "element", "exceptionToNull", "T", "f", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "exceptionToNumberFormatException", "unexpectedJson", "key", "expected", "parseLongImpl", "kotlinx-serialization-json"})
public final class JsonElementKt {
    private static final SerialDescriptor jsonUnquotedLiteralDescriptor = InlineClassDescriptorKt.InlinePrimitiveDescriptor((String)"kotlinx.serialization.json.JsonUnquotedLiteral", (KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE));

    public static final JsonPrimitive JsonPrimitive(Boolean bl) {
        if (bl == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(bl, false, null, 4, null);
    }

    public static final JsonPrimitive JsonPrimitive(Number number) {
        if (number == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(number, false, null, 4, null);
    }

    @ExperimentalSerializationApi
    public static final JsonPrimitive JsonPrimitive-7apg3OU(byte by) {
        return JsonElementKt.JsonPrimitive-VKZWuLQ(ULong.constructor-impl((long)((long)by & 0xFFL)));
    }

    @ExperimentalSerializationApi
    public static final JsonPrimitive JsonPrimitive-xj2QHRw(short s) {
        return JsonElementKt.JsonPrimitive-VKZWuLQ(ULong.constructor-impl((long)((long)s & 0xFFFFL)));
    }

    @ExperimentalSerializationApi
    public static final JsonPrimitive JsonPrimitive-WZ4Q5Ns(int n) {
        return JsonElementKt.JsonPrimitive-VKZWuLQ(ULong.constructor-impl((long)((long)n & 0xFFFFFFFFL)));
    }

    @ExperimentalSerializationApi
    public static final JsonPrimitive JsonPrimitive-VKZWuLQ(long l) {
        return JsonElementKt.JsonUnquotedLiteral(Long.toUnsignedString(l));
    }

    public static final JsonPrimitive JsonPrimitive(String string) {
        if (string == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(string, true, null, 4, null);
    }

    @ExperimentalSerializationApi
    public static final JsonNull JsonPrimitive(Void void_) {
        return JsonNull.INSTANCE;
    }

    @ExperimentalSerializationApi
    public static final JsonPrimitive JsonUnquotedLiteral(String string) {
        JsonPrimitive jsonPrimitive;
        String string2 = string;
        if (string2 == null) {
            jsonPrimitive = JsonNull.INSTANCE;
        } else {
            if (Intrinsics.areEqual((Object)string2, (Object)JsonNull.INSTANCE.getContent())) {
                throw new JsonEncodingException("Creating a literal unquoted value of 'null' is forbidden. If you want to create JSON null literal, use JsonNull object, otherwise, use JsonPrimitive");
            }
            jsonPrimitive = new JsonLiteral(string, false, jsonUnquotedLiteralDescriptor);
        }
        return jsonPrimitive;
    }

    public static final SerialDescriptor getJsonUnquotedLiteralDescriptor() {
        return jsonUnquotedLiteralDescriptor;
    }

    public static final JsonPrimitive getJsonPrimitive(JsonElement jsonElement) {
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"");
        JsonPrimitive jsonPrimitive = jsonElement instanceof JsonPrimitive ? (JsonPrimitive)jsonElement : null;
        if (jsonPrimitive == null) {
            JsonElementKt.error(jsonElement, "JsonPrimitive");
            throw new KotlinNothingValueException();
        }
        return jsonPrimitive;
    }

    public static final JsonObject getJsonObject(JsonElement jsonElement) {
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"");
        JsonObject jsonObject = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
        if (jsonObject == null) {
            JsonElementKt.error(jsonElement, "JsonObject");
            throw new KotlinNothingValueException();
        }
        return jsonObject;
    }

    public static final JsonArray getJsonArray(JsonElement jsonElement) {
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"");
        JsonArray jsonArray = jsonElement instanceof JsonArray ? (JsonArray)jsonElement : null;
        if (jsonArray == null) {
            JsonElementKt.error(jsonElement, "JsonArray");
            throw new KotlinNothingValueException();
        }
        return jsonArray;
    }

    public static final JsonNull getJsonNull(JsonElement jsonElement) {
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"");
        JsonNull jsonNull = jsonElement instanceof JsonNull ? (JsonNull)jsonElement : null;
        if (jsonNull == null) {
            JsonElementKt.error(jsonElement, "JsonNull");
            throw new KotlinNothingValueException();
        }
        return jsonNull;
    }

    public static final int getInt(JsonPrimitive jsonPrimitive) {
        long l;
        Intrinsics.checkNotNullParameter((Object)jsonPrimitive, (String)"");
        boolean bl = false;
        try {
            boolean bl2 = false;
            l = JsonElementKt.parseLongImpl(jsonPrimitive);
        }
        catch (JsonDecodingException jsonDecodingException) {
            throw new NumberFormatException(jsonDecodingException.getMessage());
        }
        long l2 = l;
        if (!(Integer.MIN_VALUE <= l2 ? l2 <= Integer.MAX_VALUE : false)) {
            throw new NumberFormatException(jsonPrimitive.getContent() + " is not an Int");
        }
        return (int)l2;
    }

    public static final Integer getIntOrNull(JsonPrimitive jsonPrimitive) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)jsonPrimitive, (String)"");
        boolean bl = false;
        try {
            boolean bl2 = false;
            l = JsonElementKt.parseLongImpl(jsonPrimitive);
        }
        catch (JsonDecodingException jsonDecodingException) {
            l = null;
        }
        Long l2 = l;
        if (l2 == null) {
            return null;
        }
        long l3 = l2;
        if (!(Integer.MIN_VALUE <= l3 ? l3 <= Integer.MAX_VALUE : false)) {
            return null;
        }
        return (int)l3;
    }

    public static final long getLong(JsonPrimitive jsonPrimitive) {
        long l;
        Intrinsics.checkNotNullParameter((Object)jsonPrimitive, (String)"");
        boolean bl = false;
        try {
            boolean bl2 = false;
            l = JsonElementKt.parseLongImpl(jsonPrimitive);
        }
        catch (JsonDecodingException jsonDecodingException) {
            throw new NumberFormatException(jsonDecodingException.getMessage());
        }
        return l;
    }

    public static final Long getLongOrNull(JsonPrimitive jsonPrimitive) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)jsonPrimitive, (String)"");
        boolean bl = false;
        try {
            boolean bl2 = false;
            l = JsonElementKt.parseLongImpl(jsonPrimitive);
        }
        catch (JsonDecodingException jsonDecodingException) {
            l = null;
        }
        return l;
    }

    public static final double getDouble(JsonPrimitive jsonPrimitive) {
        Intrinsics.checkNotNullParameter((Object)jsonPrimitive, (String)"");
        return Double.parseDouble(jsonPrimitive.getContent());
    }

    public static final Double getDoubleOrNull(JsonPrimitive jsonPrimitive) {
        Intrinsics.checkNotNullParameter((Object)jsonPrimitive, (String)"");
        return StringsKt.toDoubleOrNull((String)jsonPrimitive.getContent());
    }

    public static final float getFloat(JsonPrimitive jsonPrimitive) {
        Intrinsics.checkNotNullParameter((Object)jsonPrimitive, (String)"");
        return Float.parseFloat(jsonPrimitive.getContent());
    }

    public static final Float getFloatOrNull(JsonPrimitive jsonPrimitive) {
        Intrinsics.checkNotNullParameter((Object)jsonPrimitive, (String)"");
        return StringsKt.toFloatOrNull((String)jsonPrimitive.getContent());
    }

    public static final boolean getBoolean(JsonPrimitive jsonPrimitive) {
        Intrinsics.checkNotNullParameter((Object)jsonPrimitive, (String)"");
        Boolean bl = StringOpsKt.toBooleanStrictOrNull(jsonPrimitive.getContent());
        if (bl == null) {
            throw new IllegalStateException(jsonPrimitive + " does not represent a Boolean");
        }
        return bl;
    }

    public static final Boolean getBooleanOrNull(JsonPrimitive jsonPrimitive) {
        Intrinsics.checkNotNullParameter((Object)jsonPrimitive, (String)"");
        return StringOpsKt.toBooleanStrictOrNull(jsonPrimitive.getContent());
    }

    public static final String getContentOrNull(JsonPrimitive jsonPrimitive) {
        Intrinsics.checkNotNullParameter((Object)jsonPrimitive, (String)"");
        return jsonPrimitive instanceof JsonNull ? null : jsonPrimitive.getContent();
    }

    private static final Void error(JsonElement jsonElement, String string) {
        throw new IllegalArgumentException("Element " + Reflection.getOrCreateKotlinClass(jsonElement.getClass()) + " is not a " + string);
    }

    private static final <T> T exceptionToNull(Function0<? extends T> function0) {
        Object object;
        boolean bl = false;
        try {
            object = function0.invoke();
        }
        catch (JsonDecodingException jsonDecodingException) {
            object = null;
        }
        return (T)object;
    }

    private static final <T> T exceptionToNumberFormatException(Function0<? extends T> function0) {
        Object object;
        boolean bl = false;
        try {
            object = function0.invoke();
        }
        catch (JsonDecodingException jsonDecodingException) {
            throw new NumberFormatException(jsonDecodingException.getMessage());
        }
        return (T)object;
    }

    public static final Void unexpectedJson(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        throw new IllegalArgumentException("Element " + string + " is not a " + string2);
    }

    public static final long parseLongImpl(JsonPrimitive jsonPrimitive) {
        Intrinsics.checkNotNullParameter((Object)jsonPrimitive, (String)"");
        return new StringJsonLexer(jsonPrimitive.getContent()).consumeNumericLiteralFully();
    }
}

