/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.DecodeSequenceMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.internal.InternalJsonReader;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.JsonFriendModuleApi;
import kotlinx.serialization.json.internal.JsonIteratorKt;
import kotlinx.serialization.json.internal.ReaderJsonLexer;
import kotlinx.serialization.json.internal.ReaderJsonLexerKt;
import kotlinx.serialization.json.internal.StreamingJsonDecoder;
import kotlinx.serialization.json.internal.StreamingJsonEncoder;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.modules.SerializersModule;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a9\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f2\u0006\u0010\r\u001a\u0002H\u0006H\u0007\u00a2\u0006\u0002\u0010\u000e\u001a1\u0010\u000f\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014\u001a<\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0016\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00112\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0007\u001a1\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0016\"\u0006\b\u0000\u0010\u0006\u0018\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0087\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"SINGLE_CHAR_MAX_CODEPOINT", "", "HIGH_SURROGATE_HEADER", "LOW_SURROGATE_HEADER", "encodeByWriter", "", "T", "json", "Lkotlinx/serialization/json/Json;", "writer", "Lkotlinx/serialization/json/internal/InternalJsonWriter;", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/InternalJsonWriter;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "decodeByReader", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "reader", "Lkotlinx/serialization/json/internal/InternalJsonReader;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/DeserializationStrategy;Lkotlinx/serialization/json/internal/InternalJsonReader;)Ljava/lang/Object;", "decodeToSequenceByReader", "Lkotlin/sequences/Sequence;", "format", "Lkotlinx/serialization/json/DecodeSequenceMode;", "kotlinx-serialization-json"})
public final class JsonStreamsKt {
    private static final int SINGLE_CHAR_MAX_CODEPOINT = 65535;
    private static final int HIGH_SURROGATE_HEADER = 55232;
    private static final int LOW_SURROGATE_HEADER = 56320;

    @JsonFriendModuleApi
    public static final <T> void encodeByWriter(Json json, InternalJsonWriter internalJsonWriter, SerializationStrategy<? super T> serializationStrategy, T t) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)internalJsonWriter, (String)"");
        Intrinsics.checkNotNullParameter(serializationStrategy, (String)"");
        StreamingJsonEncoder streamingJsonEncoder = new StreamingJsonEncoder(internalJsonWriter, json, WriteMode.OBJ, new JsonEncoder[WriteMode.getEntries().size()]);
        streamingJsonEncoder.encodeSerializableValue(serializationStrategy, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonFriendModuleApi
    public static final <T> T decodeByReader(Json json, DeserializationStrategy<? extends T> deserializationStrategy, InternalJsonReader internalJsonReader) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter(deserializationStrategy, (String)"");
        Intrinsics.checkNotNullParameter((Object)internalJsonReader, (String)"");
        ReaderJsonLexer readerJsonLexer = ReaderJsonLexerKt.ReaderJsonLexer$default(json, internalJsonReader, null, 4, null);
        try {
            StreamingJsonDecoder streamingJsonDecoder = new StreamingJsonDecoder(json, WriteMode.OBJ, readerJsonLexer, deserializationStrategy.getDescriptor(), null);
            T t = streamingJsonDecoder.decodeSerializableValue(deserializationStrategy);
            readerJsonLexer.expectEof();
            T t2 = t;
            return t2;
        }
        finally {
            readerJsonLexer.release();
        }
    }

    @JsonFriendModuleApi
    @ExperimentalSerializationApi
    public static final <T> Sequence<T> decodeToSequenceByReader(Json json, InternalJsonReader internalJsonReader, DeserializationStrategy<? extends T> deserializationStrategy, DecodeSequenceMode decodeSequenceMode) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)internalJsonReader, (String)"");
        Intrinsics.checkNotNullParameter(deserializationStrategy, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)decodeSequenceMode), (String)"");
        ReaderJsonLexer readerJsonLexer = ReaderJsonLexerKt.ReaderJsonLexer(json, internalJsonReader, new char[16384]);
        Iterator<? extends T> iterator = JsonIteratorKt.JsonIterator(decodeSequenceMode, json, readerJsonLexer, deserializationStrategy);
        return SequencesKt.constrainOnce((Sequence)new Sequence<T>(iterator){
            final /* synthetic */ Iterator $iter$inlined;
            {
                this.$iter$inlined = iterator;
            }

            public Iterator<T> iterator() {
                boolean bl = false;
                return this.$iter$inlined;
            }
        });
    }

    public static /* synthetic */ Sequence decodeToSequenceByReader$default(Json json, InternalJsonReader internalJsonReader, DeserializationStrategy deserializationStrategy, DecodeSequenceMode decodeSequenceMode, int n, Object object) {
        if ((n & 8) != 0) {
            decodeSequenceMode = DecodeSequenceMode.AUTO_DETECT;
        }
        return JsonStreamsKt.decodeToSequenceByReader(json, internalJsonReader, deserializationStrategy, decodeSequenceMode);
    }

    @JsonFriendModuleApi
    @ExperimentalSerializationApi
    public static final /* synthetic */ <T> Sequence<T> decodeToSequenceByReader(Json json, InternalJsonReader internalJsonReader, DecodeSequenceMode decodeSequenceMode) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)internalJsonReader, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)decodeSequenceMode), (String)"");
        boolean bl = false;
        SerializersModule serializersModule = json.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return JsonStreamsKt.decodeToSequenceByReader(json, internalJsonReader, (DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), decodeSequenceMode);
    }

    public static /* synthetic */ Sequence decodeToSequenceByReader$default(Json json, InternalJsonReader internalJsonReader, DecodeSequenceMode decodeSequenceMode, int n, Object object) {
        if ((n & 4) != 0) {
            decodeSequenceMode = DecodeSequenceMode.AUTO_DETECT;
        }
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)internalJsonReader, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)decodeSequenceMode), (String)"");
        n = 0;
        object = json.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return JsonStreamsKt.decodeToSequenceByReader(json, internalJsonReader, (DeserializationStrategy)SerializersKt.serializer((SerializersModule)object, null), decodeSequenceMode);
    }
}

