/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.JsonFriendModuleApi;
import kotlinx.serialization.json.internal.StreamingJsonDecoder;
import kotlinx.serialization.json.internal.StringJsonLexer;
import kotlinx.serialization.json.internal.StringJsonLexerKt;
import kotlinx.serialization.json.internal.WriteMode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a9\u0010\t\u001a\u0002H\u0002\"\u0004\b\u0000\u0010\u0002*\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00020\r\u00a2\u0006\u0002\b\u000eH\u0082\b\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"decodeStringToJsonTree", "Lkotlinx/serialization/json/JsonElement;", "T", "json", "Lkotlinx/serialization/json/Json;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "source", "", "parseString", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "expectedType", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlinx/serialization/json/internal/AbstractJsonLexer;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlinx-serialization-json"})
public final class StreamingJsonDecoderKt {
    @JsonFriendModuleApi
    public static final <T> JsonElement decodeStringToJsonTree(Json json, DeserializationStrategy<? extends T> deserializationStrategy, String string) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter(deserializationStrategy, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        StringJsonLexer stringJsonLexer = StringJsonLexerKt.StringJsonLexer(json, string);
        StreamingJsonDecoder streamingJsonDecoder = new StreamingJsonDecoder(json, WriteMode.OBJ, stringJsonLexer, deserializationStrategy.getDescriptor(), null);
        JsonElement jsonElement = streamingJsonDecoder.decodeJsonElement();
        stringJsonLexer.expectEof();
        return jsonElement;
    }

    private static final <T> T parseString(AbstractJsonLexer abstractJsonLexer, String string, Function1<? super String, ? extends T> function1) {
        boolean bl = false;
        String string2 = abstractJsonLexer.consumeStringLenient();
        try {
            return (T)function1.invoke((Object)string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractJsonLexer.fail$default(abstractJsonLexer, "Failed to parse type '" + string + "' for input '" + string2 + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
    }
}

