/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.CvSize;
import org.bytedeco.opencv.opencv_core.IplROI;

@Properties(inherit={org.bytedeco.opencv.presets.opencv_core.class})
public abstract class AbstractArray
extends Pointer
implements Indexable {
    public AbstractArray(Pointer pointer) {
        super(pointer);
    }

    public abstract int arrayChannels();

    public abstract int arrayDepth();

    public abstract int arrayOrigin();

    public abstract void arrayOrigin(int var1);

    public abstract int arrayWidth();

    public abstract int arrayHeight();

    public abstract IplROI arrayROI();

    public abstract long arraySize();

    public abstract BytePointer arrayData();

    public abstract long arrayStep();

    public <B extends Buffer> B createBuffer() {
        return this.createBuffer(0);
    }

    public <B extends Buffer> B createBuffer(int n) {
        BytePointer bytePointer = this.arrayData();
        long l = this.arraySize();
        switch (this.arrayDepth()) {
            case -2147483640: 
            case 8: {
                return (B)bytePointer.position((long)n).capacity(l).asBuffer();
            }
            case -2147483632: 
            case 16: {
                return (B)new ShortPointer((Pointer)bytePointer).position((long)n).capacity(l / 2L).asBuffer();
            }
            case -2147483616: {
                return (B)new IntPointer((Pointer)bytePointer).position((long)n).capacity(l / 4L).asBuffer();
            }
            case 32: {
                return (B)new FloatPointer((Pointer)bytePointer).position((long)n).capacity(l / 4L).asBuffer();
            }
            case 64: {
                return (B)new DoublePointer((Pointer)bytePointer).position((long)n).capacity(l / 8L).asBuffer();
            }
        }
        assert (false);
        return null;
    }

    public <I extends Indexer> I createIndexer() {
        return this.createIndexer(true);
    }

    public <I extends Indexer> I createIndexer(boolean bl) {
        BytePointer bytePointer = this.arrayData();
        long l = this.arraySize();
        long[] lArray = new long[]{this.arrayHeight(), this.arrayWidth(), this.arrayChannels()};
        long[] lArray2 = new long[]{this.arrayStep(), this.arrayChannels(), 1L};
        switch (this.arrayDepth()) {
            case 8: {
                return (I)UByteIndexer.create((BytePointer)bytePointer.capacity(l), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
            case -2147483640: {
                return (I)ByteIndexer.create((BytePointer)bytePointer.capacity(l), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
            case 16: {
                lArray2[0] = lArray2[0] / 2L;
                return (I)UShortIndexer.create((ShortPointer)new ShortPointer((Pointer)bytePointer).capacity(l / 2L), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
            case -2147483632: {
                lArray2[0] = lArray2[0] / 2L;
                return (I)ShortIndexer.create((ShortPointer)new ShortPointer((Pointer)bytePointer).capacity(l / 2L), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
            case -2147483616: {
                lArray2[0] = lArray2[0] / 4L;
                return (I)IntIndexer.create((IntPointer)new IntPointer((Pointer)bytePointer).capacity(l / 4L), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
            case 32: {
                lArray2[0] = lArray2[0] / 4L;
                return (I)FloatIndexer.create((FloatPointer)new FloatPointer((Pointer)bytePointer).capacity(l / 4L), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
            case 64: {
                lArray2[0] = lArray2[0] / 8L;
                return (I)DoubleIndexer.create((DoublePointer)new DoublePointer((Pointer)bytePointer).capacity(l / 8L), (long[])lArray, (long[])lArray2, (boolean)bl).indexable((Indexable)this);
            }
        }
        assert (false);
        return null;
    }

    public double highValue() {
        double d = 0.0;
        switch (this.arrayDepth()) {
            case 8: {
                d = 255.0;
                break;
            }
            case 16: {
                d = 65535.0;
                break;
            }
            case -2147483640: {
                d = 127.0;
                break;
            }
            case -2147483632: {
                d = 32767.0;
                break;
            }
            case -2147483616: {
                d = 2.147483647E9;
                break;
            }
            case 1: 
            case 32: 
            case 64: {
                d = 1.0;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return d;
    }

    public CvSize cvSize() {
        return opencv_core.cvSize(this.arrayWidth(), this.arrayHeight());
    }

    @Deprecated
    public ByteBuffer getByteBuffer(int n) {
        return this.arrayData().position((long)n).capacity(this.arraySize()).asByteBuffer();
    }

    @Deprecated
    public ShortBuffer getShortBuffer(int n) {
        return this.getByteBuffer(n * 2).asShortBuffer();
    }

    @Deprecated
    public IntBuffer getIntBuffer(int n) {
        return this.getByteBuffer(n * 4).asIntBuffer();
    }

    @Deprecated
    public FloatBuffer getFloatBuffer(int n) {
        return this.getByteBuffer(n * 4).asFloatBuffer();
    }

    @Deprecated
    public DoubleBuffer getDoubleBuffer(int n) {
        return this.getByteBuffer(n * 8).asDoubleBuffer();
    }

    @Deprecated
    public ByteBuffer getByteBuffer() {
        return this.getByteBuffer(0);
    }

    @Deprecated
    public ShortBuffer getShortBuffer() {
        return this.getShortBuffer(0);
    }

    @Deprecated
    public IntBuffer getIntBuffer() {
        return this.getIntBuffer(0);
    }

    @Deprecated
    public FloatBuffer getFloatBuffer() {
        return this.getFloatBuffer(0);
    }

    @Deprecated
    public DoubleBuffer getDoubleBuffer() {
        return this.getDoubleBuffer(0);
    }

    public String toString() {
        if (this.isNull()) {
            return super.toString();
        }
        try {
            return ((Object)((Object)this)).getClass().getName() + "[width=" + this.arrayWidth() + ",height=" + this.arrayHeight() + ",depth=" + this.arrayDepth() + ",channels=" + this.arrayChannels() + "]";
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    static {
        Loader.load();
    }
}

