/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<std::vector<float> >"})
@Properties(inherit={opencv_core.class})
public class FloatVectorVector
extends Pointer {
    public FloatVectorVector(Pointer pointer) {
        super(pointer);
    }

    public FloatVectorVector(float[] ... fArray) {
        this(fArray.length);
        this.put(fArray);
    }

    public FloatVectorVector() {
        this.allocate();
    }

    public FloatVectorVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native FloatVectorVector put(@ByRef FloatVectorVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public boolean empty(@Cast(value={"size_t"}) long l) {
        return this.size(l) == 0L;
    }

    @Index(function="at")
    public native long size(@Cast(value={"size_t"}) long var1);

    public void clear(@Cast(value={"size_t"}) long l) {
        this.resize(l, 0L);
    }

    @Index(function="at")
    public native void resize(@Cast(value={"size_t"}) long var1, @Cast(value={"size_t"}) long var3);

    @Index(function="at")
    public native float get(@Cast(value={"size_t"}) long var1, @Cast(value={"size_t"}) long var3);

    public native FloatVectorVector put(@Cast(value={"size_t"}) long var1, @Cast(value={"size_t"}) long var3, float var5);

    public float[][] get() {
        float[][] fArrayArray = new float[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE][];
        for (int i = 0; i < fArrayArray.length; ++i) {
            fArrayArray[i] = new float[this.size(i) < Integer.MAX_VALUE ? (int)this.size(i) : Integer.MAX_VALUE];
            for (int j = 0; j < fArrayArray[i].length; ++j) {
                fArrayArray[i][j] = this.get(i, j);
            }
        }
        return fArrayArray;
    }

    public String toString() {
        return Arrays.deepToString((Object[])this.get());
    }

    public FloatVectorVector put(float[] ... fArray) {
        if (this.size() != (long)fArray.length) {
            this.resize(fArray.length);
        }
        for (int i = 0; i < fArray.length; ++i) {
            if (this.size(i) != (long)fArray[i].length) {
                this.resize(i, fArray[i].length);
            }
            for (int j = 0; j < fArray[i].length; ++j) {
                this.put(i, j, fArray[i][j]);
            }
        }
        return this;
    }

    static {
        Loader.load();
    }
}

