/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.GpuMat;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<cv::cuda::GpuMat>"})
@Properties(inherit={opencv_core.class})
public class GpuMatVector
extends Pointer {
    public GpuMatVector(Pointer pointer) {
        super(pointer);
    }

    public GpuMatVector(GpuMat gpuMat) {
        this(1L);
        this.put(0L, gpuMat);
    }

    public GpuMatVector(GpuMat ... gpuMatArray) {
        this(gpuMatArray.length);
        this.put(gpuMatArray);
    }

    public GpuMatVector() {
        this.allocate();
    }

    public GpuMatVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native GpuMatVector put(@ByRef GpuMatVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public GpuMat front() {
        return this.get(0L);
    }

    public GpuMat back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native GpuMat get(@Cast(value={"size_t"}) long var1);

    public native GpuMatVector put(@Cast(value={"size_t"}) long var1, GpuMat var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef GpuMat var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public GpuMat[] get() {
        GpuMat[] gpuMatArray = new GpuMat[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < gpuMatArray.length; ++i) {
            gpuMatArray[i] = this.get(i);
        }
        return gpuMatArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public GpuMat pop_back() {
        long l = this.size();
        GpuMat gpuMat = this.get(l - 1L);
        this.resize(l - 1L);
        return gpuMat;
    }

    public GpuMatVector push_back(GpuMat gpuMat) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, gpuMat);
    }

    public GpuMatVector put(GpuMat gpuMat) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, gpuMat);
    }

    public GpuMatVector put(GpuMat ... gpuMatArray) {
        if (this.size() != (long)gpuMatArray.length) {
            this.resize(gpuMatArray.length);
        }
        for (int i = 0; i < gpuMatArray.length; ++i) {
            this.put(i, gpuMatArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native GpuMat get();
    }
}

