/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Point2fVector;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<std::vector<cv::Point2f> >"})
@Properties(inherit={opencv_core.class})
public class Point2fVectorVector
extends Pointer {
    public Point2fVectorVector(Pointer pointer) {
        super(pointer);
    }

    public Point2fVectorVector(Point2fVector point2fVector) {
        this(1L);
        this.put(0L, point2fVector);
    }

    public Point2fVectorVector(Point2fVector ... point2fVectorArray) {
        this(point2fVectorArray.length);
        this.put(point2fVectorArray);
    }

    public Point2fVectorVector() {
        this.allocate();
    }

    public Point2fVectorVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native Point2fVectorVector put(@ByRef Point2fVectorVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Point2fVector front() {
        return this.get(0L);
    }

    public Point2fVector back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native Point2fVector get(@Cast(value={"size_t"}) long var1);

    public native Point2fVectorVector put(@Cast(value={"size_t"}) long var1, Point2fVector var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef Point2fVector var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Point2fVector[] get() {
        Point2fVector[] point2fVectorArray = new Point2fVector[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < point2fVectorArray.length; ++i) {
            point2fVectorArray[i] = this.get(i);
        }
        return point2fVectorArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Point2fVector pop_back() {
        long l = this.size();
        Point2fVector point2fVector = this.get(l - 1L);
        this.resize(l - 1L);
        return point2fVector;
    }

    public Point2fVectorVector push_back(Point2fVector point2fVector) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, point2fVector);
    }

    public Point2fVectorVector put(Point2fVector point2fVector) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, point2fVector);
    }

    public Point2fVectorVector put(Point2fVector ... point2fVectorArray) {
        if (this.size() != (long)point2fVectorArray.length) {
            this.resize(point2fVectorArray.length);
        }
        for (int i = 0; i < point2fVectorArray.length; ++i) {
            this.put(i, point2fVectorArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native Point2fVector get();
    }
}

