/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Range;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<cv::Range>"})
@Properties(inherit={opencv_core.class})
public class RangeVector
extends Pointer {
    public RangeVector(Pointer pointer) {
        super(pointer);
    }

    public RangeVector(Range range) {
        this(1L);
        this.put(0L, range);
    }

    public RangeVector(Range ... rangeArray) {
        this(rangeArray.length);
        this.put(rangeArray);
    }

    public RangeVector() {
        this.allocate();
    }

    public RangeVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native RangeVector put(@ByRef RangeVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Range front() {
        return this.get(0L);
    }

    public Range back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native Range get(@Cast(value={"size_t"}) long var1);

    public native RangeVector put(@Cast(value={"size_t"}) long var1, Range var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef Range var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Range[] get() {
        Range[] rangeArray = new Range[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < rangeArray.length; ++i) {
            rangeArray[i] = this.get(i);
        }
        return rangeArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Range pop_back() {
        long l = this.size();
        Range range = this.get(l - 1L);
        this.resize(l - 1L);
        return range;
    }

    public RangeVector push_back(Range range) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, range);
    }

    public RangeVector put(Range range) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, range);
    }

    public RangeVector put(Range ... rangeArray) {
        if (this.size() != (long)rangeArray.length) {
            this.resize(rangeArray.length);
        }
        for (int i = 0; i < rangeArray.length; ++i) {
            this.put(i, rangeArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native Range get();
    }
}

