/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_imgproc;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Scalar4i;
import org.bytedeco.opencv.presets.opencv_imgproc;

@Name(value={"std::vector<cv::Vec4i>"})
@Properties(inherit={opencv_imgproc.class})
public class Vec4iVector
extends Pointer {
    public Vec4iVector(Pointer pointer) {
        super(pointer);
    }

    public Vec4iVector(Scalar4i scalar4i) {
        this(1L);
        this.put(0L, scalar4i);
    }

    public Vec4iVector(Scalar4i ... scalar4iArray) {
        this(scalar4iArray.length);
        this.put(scalar4iArray);
    }

    public Vec4iVector() {
        this.allocate();
    }

    public Vec4iVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native Vec4iVector put(@ByRef Vec4iVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Scalar4i front() {
        return this.get(0L);
    }

    public Scalar4i back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @Cast(value={"cv::Vec4i*"})
    @ByRef
    public native Scalar4i get(@Cast(value={"size_t"}) long var1);

    public native Vec4iVector put(@Cast(value={"size_t"}) long var1, Scalar4i var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @Cast(value={"cv::Vec4i*"}) @ByRef Scalar4i var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Scalar4i[] get() {
        Scalar4i[] scalar4iArray = new Scalar4i[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < scalar4iArray.length; ++i) {
            scalar4iArray[i] = this.get(i);
        }
        return scalar4iArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Scalar4i pop_back() {
        long l = this.size();
        Scalar4i scalar4i = this.get(l - 1L);
        this.resize(l - 1L);
        return scalar4i;
    }

    public Vec4iVector push_back(Scalar4i scalar4i) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, scalar4i);
    }

    public Vec4iVector put(Scalar4i scalar4i) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, scalar4i);
    }

    public Vec4iVector put(Scalar4i ... scalar4iArray) {
        if (this.size() != (long)scalar4iArray.length) {
            this.resize(scalar4iArray.length);
        }
        for (int i = 0; i < scalar4iArray.length; ++i) {
            this.put(i, scalar4iArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @Cast(value={"cv::Vec4i*"})
        @ByRef
        @Const
        public native Scalar4i get();
    }
}

