/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_stitching;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_stitching.CameraParams;
import org.bytedeco.opencv.presets.opencv_stitching;

@Name(value={"std::vector<cv::detail::CameraParams>"})
@Properties(inherit={opencv_stitching.class})
public class CameraParamsVector
extends Pointer {
    public CameraParamsVector(Pointer pointer) {
        super(pointer);
    }

    public CameraParamsVector(CameraParams cameraParams) {
        this(1L);
        this.put(0L, cameraParams);
    }

    public CameraParamsVector(CameraParams ... cameraParamsArray) {
        this(cameraParamsArray.length);
        this.put(cameraParamsArray);
    }

    public CameraParamsVector() {
        this.allocate();
    }

    public CameraParamsVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native CameraParamsVector put(@ByRef CameraParamsVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public CameraParams front() {
        return this.get(0L);
    }

    public CameraParams back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native CameraParams get(@Cast(value={"size_t"}) long var1);

    public native CameraParamsVector put(@Cast(value={"size_t"}) long var1, CameraParams var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef CameraParams var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public CameraParams[] get() {
        CameraParams[] cameraParamsArray = new CameraParams[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < cameraParamsArray.length; ++i) {
            cameraParamsArray[i] = this.get(i);
        }
        return cameraParamsArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public CameraParams pop_back() {
        long l = this.size();
        CameraParams cameraParams = this.get(l - 1L);
        this.resize(l - 1L);
        return cameraParams;
    }

    public CameraParamsVector push_back(CameraParams cameraParams) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, cameraParams);
    }

    public CameraParamsVector put(CameraParams cameraParams) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, cameraParams);
    }

    public CameraParamsVector put(CameraParams ... cameraParamsArray) {
        if (this.size() != (long)cameraParamsArray.length) {
            this.resize(cameraParamsArray.length);
        }
        for (int i = 0; i < cameraParamsArray.length; ++i) {
            this.put(i, cameraParamsArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native CameraParams get();
    }
}

