/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_stitching;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_stitching.ImageFeatures;
import org.bytedeco.opencv.presets.opencv_stitching;

@Name(value={"std::vector<cv::detail::ImageFeatures>"})
@Properties(inherit={opencv_stitching.class})
public class ImageFeaturesVector
extends Pointer {
    public ImageFeaturesVector(Pointer pointer) {
        super(pointer);
    }

    public ImageFeaturesVector(ImageFeatures imageFeatures) {
        this(1L);
        this.put(0L, imageFeatures);
    }

    public ImageFeaturesVector(ImageFeatures ... imageFeaturesArray) {
        this(imageFeaturesArray.length);
        this.put(imageFeaturesArray);
    }

    public ImageFeaturesVector() {
        this.allocate();
    }

    public ImageFeaturesVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native ImageFeaturesVector put(@ByRef ImageFeaturesVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public ImageFeatures front() {
        return this.get(0L);
    }

    public ImageFeatures back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native ImageFeatures get(@Cast(value={"size_t"}) long var1);

    public native ImageFeaturesVector put(@Cast(value={"size_t"}) long var1, ImageFeatures var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef ImageFeatures var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public ImageFeatures[] get() {
        ImageFeatures[] imageFeaturesArray = new ImageFeatures[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < imageFeaturesArray.length; ++i) {
            imageFeaturesArray[i] = this.get(i);
        }
        return imageFeaturesArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public ImageFeatures pop_back() {
        long l = this.size();
        ImageFeatures imageFeatures = this.get(l - 1L);
        this.resize(l - 1L);
        return imageFeatures;
    }

    public ImageFeaturesVector push_back(ImageFeatures imageFeatures) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, imageFeatures);
    }

    public ImageFeaturesVector put(ImageFeatures imageFeatures) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, imageFeatures);
    }

    public ImageFeaturesVector put(ImageFeatures ... imageFeaturesArray) {
        if (this.size() != (long)imageFeaturesArray.length) {
            this.resize(imageFeaturesArray.length);
        }
        for (int i = 0; i < imageFeaturesArray.length; ++i) {
            this.put(i, imageFeaturesArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native ImageFeatures get();
    }
}

