/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_text;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.presets.opencv_text;

@Name(value={"std::vector<int>"})
@Properties(inherit={opencv_text.class})
public class IntVector
extends Pointer {
    public IntVector(Pointer pointer) {
        super(pointer);
    }

    public IntVector(int ... nArray) {
        this((long)nArray.length);
        this.put(nArray);
    }

    public IntVector() {
        this.allocate();
    }

    public IntVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native IntVector put(@ByRef IntVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public int front() {
        return this.get(0L);
    }

    public int back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    public native int get(@Cast(value={"size_t"}) long var1);

    public native IntVector put(@Cast(value={"size_t"}) long var1, int var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, int var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public int[] get() {
        int[] nArray = new int[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.get(i);
        }
        return nArray;
    }

    public String toString() {
        return Arrays.toString(this.get());
    }

    public int pop_back() {
        long l = this.size();
        int n = this.get(l - 1L);
        this.resize(l - 1L);
        return n;
    }

    public IntVector push_back(int n) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, n);
    }

    public IntVector put(int n) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, n);
    }

    public IntVector put(int ... nArray) {
        if (this.size() != (long)nArray.length) {
            this.resize(nArray.length);
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.put((long)i, nArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        public native int get();
    }
}

