/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u001a\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\b\u0010\u0005\u001a%\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\b\u0010\u000b\u001a)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0002*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a+\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u0011*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a#\u0010\u0018\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001aE\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u001c\u0010\u001c\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\u001aj\b\u0012\u0004\u0012\u00020\u0003`\u001b0\u00122\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a=\u0010 \u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u001c\u0010\u001f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000e0\u001aj\b\u0012\u0004\u0012\u00020\u000e`\u001b0\u0012H\u0002\u00a2\u0006\u0004\b \u0010!\u001a+\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b#\u0010$\u001a+\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b%\u0010$\u001a\u001b\u0010&\u001a\u00020\t*\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b&\u0010'\u00a8\u0006("}, d2={"", "header", "", "Lio/ktor/http/HeaderValue;", "parseAndSortHeader", "(Ljava/lang/String;)Ljava/util/List;", "parseAndSortContentTypeHeader", "text", "parseHeaderValue", "", "parametersOnly", "(Ljava/lang/String;Z)Ljava/util/List;", "", "Lkotlin/Pair;", "Lio/ktor/http/HeaderValueParam;", "toHeaderParamsList", "(Ljava/lang/Iterable;)Ljava/util/List;", "T", "Lkotlin/Lazy;", "valueOrEmpty", "(Lkotlin/Lazy;)Ljava/util/List;", "", "start", "end", "subtrim", "(Ljava/lang/String;II)Ljava/lang/String;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "items", "parseHeaderValueItem", "(Ljava/lang/String;ILkotlin/Lazy;Z)I", "parameters", "parseHeaderValueParameter", "(Ljava/lang/String;ILkotlin/Lazy;)I", "value", "parseHeaderValueParameterValue", "(Ljava/lang/String;I)Lkotlin/Pair;", "parseHeaderValueParameterValueQuoted", "nextIsSemicolonOrEnd", "(Ljava/lang/String;I)Z", "ktor-http"})
public final class HttpHeaderValueParserKt {
    public static final List<HeaderValue> parseAndSortHeader(String string) {
        Iterable iterable = HttpHeaderValueParserKt.parseHeaderValue(string);
        boolean bl = false;
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

            public final int compare(T t, T t2) {
                HeaderValue headerValue = (HeaderValue)t2;
                boolean bl = false;
                Comparable comparable = Double.valueOf(headerValue.getQuality());
                headerValue = (HeaderValue)t;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(headerValue.getQuality()));
            }
        });
    }

    public static final List<HeaderValue> parseAndSortContentTypeHeader(String string) {
        Comparator comparator = new Comparator(){

            public final int compare(T t, T t2) {
                HeaderValue headerValue = (HeaderValue)t2;
                boolean bl = false;
                Comparable comparable = Double.valueOf(headerValue.getQuality());
                headerValue = (HeaderValue)t;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(headerValue.getQuality()));
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = comparator;
            }

            public final int compare(T t, T t2) {
                int n;
                int n2 = this.$this_thenBy.compare(t, t2);
                if (n2 != 0) {
                    n = n2;
                } else {
                    HeaderValue headerValue = (HeaderValue)t;
                    boolean bl = false;
                    ContentType contentType = ContentType.Companion.parse(headerValue.getValue());
                    int n3 = 0;
                    if (Intrinsics.areEqual((Object)contentType.getContentType(), (Object)"*")) {
                        n3 += 2;
                    }
                    if (Intrinsics.areEqual((Object)contentType.getContentSubtype(), (Object)"*")) {
                        ++n3;
                    }
                    headerValue = (HeaderValue)t2;
                    Comparable comparable = Integer.valueOf(n3);
                    bl = false;
                    contentType = ContentType.Companion.parse(headerValue.getValue());
                    n3 = 0;
                    if (Intrinsics.areEqual((Object)contentType.getContentType(), (Object)"*")) {
                        n3 += 2;
                    }
                    if (Intrinsics.areEqual((Object)contentType.getContentSubtype(), (Object)"*")) {
                        ++n3;
                    }
                    n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n3));
                }
                return n;
            }
        };
        return CollectionsKt.sortedWith((Iterable)HttpHeaderValueParserKt.parseHeaderValue(string), (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = comparator;
            }

            public final int compare(T t, T t2) {
                int n;
                int n2 = this.$this_thenByDescending.compare(t, t2);
                if (n2 != 0) {
                    n = n2;
                } else {
                    HeaderValue headerValue = (HeaderValue)t2;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(headerValue.getParams().size());
                    headerValue = (HeaderValue)t;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(headerValue.getParams().size()));
                }
                return n;
            }
        });
    }

    public static final List<HeaderValue> parseHeaderValue(String string) {
        return HttpHeaderValueParserKt.parseHeaderValue(string, false);
    }

    public static final List<HeaderValue> parseHeaderValue(String string, boolean bl) {
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        int n = 0;
        Lazy lazy = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, HttpHeaderValueParserKt::parseHeaderValue$lambda$4);
        while (n <= StringsKt.getLastIndex((CharSequence)string)) {
            n = HttpHeaderValueParserKt.parseHeaderValueItem(string, n, (Lazy<? extends ArrayList<HeaderValue>>)lazy, bl);
        }
        return HttpHeaderValueParserKt.valueOrEmpty(lazy);
    }

    public static final List<HeaderValueParam> toHeaderParamsList(Iterable<Pair<String, String>> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"");
        Iterable<Pair<String, String>> iterable2 = iterable;
        boolean bl = false;
        Iterable<Pair<String, String>> iterable3 = iterable2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable2, (int)10));
        boolean bl2 = false;
        Iterator<Pair<String, String>> iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            Pair<String, String> pair;
            Pair<String, String> pair2 = pair = iterator.next();
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new HeaderValueParam((String)pair2.getFirst(), (String)pair2.getSecond()));
        }
        return (List)collection;
    }

    private static final <T> List<T> valueOrEmpty(Lazy<? extends List<? extends T>> lazy) {
        return lazy.isInitialized() ? (List)lazy.getValue() : CollectionsKt.emptyList();
    }

    private static final String subtrim(String string, int n, int n2) {
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    private static final int parseHeaderValueItem(String string, int n, Lazy<? extends ArrayList<HeaderValue>> lazy, boolean bl) {
        Integer n2;
        int n3 = n;
        Lazy lazy2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, HttpHeaderValueParserKt::parseHeaderValueItem$lambda$6);
        Integer n4 = n2 = bl ? Integer.valueOf(n3) : null;
        block4: while (n3 <= StringsKt.getLastIndex((CharSequence)string)) {
            switch (string.charAt(n3)) {
                case ',': {
                    Integer n5 = n2;
                    ((ArrayList)lazy.getValue()).add(new HeaderValue(HttpHeaderValueParserKt.subtrim(string, n, n5 != null ? n5 : n3), HttpHeaderValueParserKt.valueOrEmpty(lazy2)));
                    return n3 + 1;
                }
                case ';': {
                    if (n2 == null) {
                        n2 = n3;
                    }
                    n3 = HttpHeaderValueParserKt.parseHeaderValueParameter(string, n3 + 1, (Lazy<? extends ArrayList<HeaderValueParam>>)lazy2);
                    continue block4;
                }
            }
            n3 = bl ? HttpHeaderValueParserKt.parseHeaderValueParameter(string, n3, (Lazy<? extends ArrayList<HeaderValueParam>>)lazy2) : n3 + 1;
        }
        Integer n6 = n2;
        ((ArrayList)lazy.getValue()).add(new HeaderValue(HttpHeaderValueParserKt.subtrim(string, n, n6 != null ? n6 : n3), HttpHeaderValueParserKt.valueOrEmpty(lazy2)));
        return n3;
    }

    private static final int parseHeaderValueParameter(String string, int n, Lazy<? extends ArrayList<HeaderValueParam>> lazy) {
        int n2;
        for (n2 = n; n2 <= StringsKt.getLastIndex((CharSequence)string); ++n2) {
            switch (string.charAt(n2)) {
                case '=': {
                    Pair<Integer, String> pair = HttpHeaderValueParserKt.parseHeaderValueParameterValue(string, n2 + 1);
                    int n3 = ((Number)pair.component1()).intValue();
                    String string2 = (String)pair.component2();
                    HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(lazy, string, n, n2, string2);
                    return n3;
                }
                case ',': 
                case ';': {
                    HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(lazy, string, n, n2, "");
                    return n2;
                }
            }
        }
        HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(lazy, string, n, n2, "");
        return n2;
    }

    private static final Pair<Integer, String> parseHeaderValueParameterValue(String string, int n) {
        int n2;
        if (string.length() == n) {
            return TuplesKt.to((Object)n, (Object)"");
        }
        if (string.charAt(n) == '\"') {
            return HttpHeaderValueParserKt.parseHeaderValueParameterValueQuoted(string, n2 + 1);
        }
        for (n2 = n; n2 <= StringsKt.getLastIndex((CharSequence)string); ++n2) {
            switch (string.charAt(n2)) {
                case ',': 
                case ';': {
                    return TuplesKt.to((Object)n2, (Object)HttpHeaderValueParserKt.subtrim(string, n, n2));
                }
            }
        }
        return TuplesKt.to((Object)n2, (Object)HttpHeaderValueParserKt.subtrim(string, n, n2));
    }

    private static final Pair<Integer, String> parseHeaderValueParameterValueQuoted(String string, int n) {
        char c;
        int n2 = n;
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 <= StringsKt.getLastIndex((CharSequence)string)) {
            c = string.charAt(n2);
            if (c == '\"' && HttpHeaderValueParserKt.nextIsSemicolonOrEnd(string, n2)) {
                return TuplesKt.to((Object)(n2 + 1), (Object)stringBuilder.toString());
            }
            if (c == '\\' && n2 < StringsKt.getLastIndex((CharSequence)string) - 2) {
                stringBuilder.append(string.charAt(n2 + 1));
                n2 += 2;
                continue;
            }
            stringBuilder.append(c);
            ++n2;
        }
        Integer n3 = n2;
        c = '\"';
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        String string3 = string2;
        return TuplesKt.to((Object)n3, (Object)(c + string3));
    }

    private static final boolean nextIsSemicolonOrEnd(String string, int n) {
        int n2;
        for (n2 = n + 1; n2 < string.length() && string.charAt(n2) == ' '; ++n2) {
        }
        return n2 == string.length() || string.charAt(n2) == ';';
    }

    private static final ArrayList parseHeaderValue$lambda$4() {
        return new ArrayList();
    }

    private static final ArrayList parseHeaderValueItem$lambda$6() {
        return new ArrayList();
    }

    private static final void parseHeaderValueParameter$addParam(Lazy<? extends ArrayList<HeaderValueParam>> lazy, String string, int n, int n2, String string2) {
        String string3 = HttpHeaderValueParserKt.subtrim(string, n, n2);
        if (((CharSequence)string3).length() == 0) {
            return;
        }
        ((ArrayList)lazy.getValue()).add(new HeaderValueParam(string3, string2));
    }
}

