/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.Cookie;
import io.ktor.http.CookieKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessageBuilder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0019\u0010\b\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0019\u0010\f\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0019\u0010\u000f\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\r\u001a\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0010\u001a\u0019\u0010\u0013\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012*\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u0013\u0010\u0015\u001a\u0004\u0018\u00010\n*\u00020\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0019\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0017*\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001a*\u00020\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u001d\u00a2\u0006\u0004\b\u0004\u0010\u001e\u001a\u0019\u0010\u0013\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012*\u00020\u001d\u00a2\u0006\u0004\b\u0013\u0010\u001f\u001a\u0013\u0010\u0015\u001a\u0004\u0018\u00010\n*\u00020\u001d\u00a2\u0006\u0004\b\u0015\u0010 \u001a\u0019\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0017*\u00020\u001d\u00a2\u0006\u0004\b\u0018\u0010!\u001a\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001a*\u00020\u001d\u00a2\u0006\u0004\b\u001b\u0010\"\u001a\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u0017*\u00020\u001d\u00a2\u0006\u0004\b$\u0010!\u001a\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020#0\u0017*\u00020\u0000\u00a2\u0006\u0004\b%\u0010\u0019\u001a\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020&0\u0017*\u00020\u001d\u00a2\u0006\u0004\b'\u0010!\u001a\u0019\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\u0017*\u00020\nH\u0000\u00a2\u0006\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lio/ktor/http/HttpMessageBuilder;", "Lio/ktor/http/ContentType;", "type", "", "contentType", "(Lio/ktor/http/HttpMessageBuilder;Lio/ktor/http/ContentType;)V", "", "seconds", "maxAge", "(Lio/ktor/http/HttpMessageBuilder;I)V", "", "value", "ifNoneMatch", "(Lio/ktor/http/HttpMessageBuilder;Ljava/lang/String;)V", "content", "userAgent", "(Lio/ktor/http/HttpMessageBuilder;)Lio/ktor/http/ContentType;", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "charset", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/nio/charset/Charset;", "etag", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/lang/String;", "", "vary", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/util/List;", "", "contentLength", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/lang/Long;", "Lio/ktor/http/HttpMessage;", "(Lio/ktor/http/HttpMessage;)Lio/ktor/http/ContentType;", "(Lio/ktor/http/HttpMessage;)Ljava/nio/charset/Charset;", "(Lio/ktor/http/HttpMessage;)Ljava/lang/String;", "(Lio/ktor/http/HttpMessage;)Ljava/util/List;", "(Lio/ktor/http/HttpMessage;)Ljava/lang/Long;", "Lio/ktor/http/Cookie;", "setCookie", "cookies", "Lio/ktor/http/HeaderValue;", "cacheControl", "splitSetCookieHeader", "(Ljava/lang/String;)Ljava/util/List;", "ktor-http"})
public final class HttpMessagePropertiesKt {
    public static final void contentType(HttpMessageBuilder httpMessageBuilder, ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)httpMessageBuilder, (String)"");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"");
        httpMessageBuilder.getHeaders().set(HttpHeaders.INSTANCE.getContentType(), contentType.toString());
    }

    public static final void maxAge(HttpMessageBuilder httpMessageBuilder, int n) {
        Intrinsics.checkNotNullParameter((Object)httpMessageBuilder, (String)"");
        httpMessageBuilder.getHeaders().append(HttpHeaders.INSTANCE.getCacheControl(), "max-age=" + n);
    }

    public static final void ifNoneMatch(HttpMessageBuilder httpMessageBuilder, String string) {
        Intrinsics.checkNotNullParameter((Object)httpMessageBuilder, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        httpMessageBuilder.getHeaders().set(HttpHeaders.INSTANCE.getIfNoneMatch(), string);
    }

    public static final void userAgent(HttpMessageBuilder httpMessageBuilder, String string) {
        Intrinsics.checkNotNullParameter((Object)httpMessageBuilder, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        httpMessageBuilder.getHeaders().set(HttpHeaders.INSTANCE.getUserAgent(), string);
    }

    public static final ContentType contentType(HttpMessageBuilder httpMessageBuilder) {
        ContentType contentType;
        Intrinsics.checkNotNullParameter((Object)httpMessageBuilder, (String)"");
        String string = httpMessageBuilder.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            contentType = ContentType.Companion.parse(string2);
        } else {
            contentType = null;
        }
        return contentType;
    }

    public static final Charset charset(HttpMessageBuilder httpMessageBuilder) {
        Intrinsics.checkNotNullParameter((Object)httpMessageBuilder, (String)"");
        ContentType contentType = HttpMessagePropertiesKt.contentType(httpMessageBuilder);
        return contentType != null ? ContentTypesKt.charset(contentType) : null;
    }

    public static final String etag(HttpMessageBuilder httpMessageBuilder) {
        Intrinsics.checkNotNullParameter((Object)httpMessageBuilder, (String)"");
        return httpMessageBuilder.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    public static final List<String> vary(HttpMessageBuilder httpMessageBuilder) {
        List list;
        Intrinsics.checkNotNullParameter((Object)httpMessageBuilder, (String)"");
        List list2 = httpMessageBuilder.getHeaders().getAll(HttpHeaders.INSTANCE.getVary());
        if (list2 != null) {
            Iterable iterable = list2;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList();
            boolean bl2 = false;
            for (Object t : iterable2) {
                Object object = (String)t;
                boolean bl3 = false;
                Object object2 = new String[]{","};
                object2 = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])object2, (boolean)false, (int)0, (int)6, null);
                boolean bl4 = false;
                Object object3 = object2;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
                boolean bl5 = false;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    Object t2 = iterator.next();
                    String string = (String)t2;
                    Collection collection3 = collection2;
                    boolean bl6 = false;
                    collection3.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                }
                object = (List)collection2;
                CollectionsKt.addAll((Collection)collection, (Iterable)object);
            }
            list = (List)collection;
        } else {
            list = null;
        }
        return list;
    }

    public static final Long contentLength(HttpMessageBuilder httpMessageBuilder) {
        Intrinsics.checkNotNullParameter((Object)httpMessageBuilder, (String)"");
        String string = httpMessageBuilder.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    public static final ContentType contentType(HttpMessage httpMessage) {
        ContentType contentType;
        Intrinsics.checkNotNullParameter((Object)httpMessage, (String)"");
        String string = httpMessage.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            contentType = ContentType.Companion.parse(string2);
        } else {
            contentType = null;
        }
        return contentType;
    }

    public static final Charset charset(HttpMessage httpMessage) {
        Intrinsics.checkNotNullParameter((Object)httpMessage, (String)"");
        ContentType contentType = HttpMessagePropertiesKt.contentType(httpMessage);
        return contentType != null ? ContentTypesKt.charset(contentType) : null;
    }

    public static final String etag(HttpMessage httpMessage) {
        Intrinsics.checkNotNullParameter((Object)httpMessage, (String)"");
        return httpMessage.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    public static final List<String> vary(HttpMessage httpMessage) {
        List list;
        Intrinsics.checkNotNullParameter((Object)httpMessage, (String)"");
        List list2 = httpMessage.getHeaders().getAll(HttpHeaders.INSTANCE.getVary());
        if (list2 != null) {
            Iterable iterable = list2;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList();
            boolean bl2 = false;
            for (Object t : iterable2) {
                Object object = (String)t;
                boolean bl3 = false;
                Object object2 = new String[]{","};
                object2 = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])object2, (boolean)false, (int)0, (int)6, null);
                boolean bl4 = false;
                Object object3 = object2;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
                boolean bl5 = false;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    Object t2 = iterator.next();
                    String string = (String)t2;
                    Collection collection3 = collection2;
                    boolean bl6 = false;
                    collection3.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                }
                object = (List)collection2;
                CollectionsKt.addAll((Collection)collection, (Iterable)object);
            }
            list = (List)collection;
        } else {
            list = null;
        }
        return list;
    }

    public static final Long contentLength(HttpMessage httpMessage) {
        Intrinsics.checkNotNullParameter((Object)httpMessage, (String)"");
        String string = httpMessage.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    public static final List<Cookie> setCookie(HttpMessage httpMessage) {
        List list;
        Intrinsics.checkNotNullParameter((Object)httpMessage, (String)"");
        List list2 = httpMessage.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            Iterable iterable = list2;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Iterable iterable3 = new ArrayList();
            boolean bl2 = false;
            for (Object object : iterable2) {
                Object object2 = (String)object;
                boolean bl3 = false;
                object2 = HttpMessagePropertiesKt.splitSetCookieHeader((String)object2);
                CollectionsKt.addAll((Collection)iterable3, (Iterable)object2);
            }
            Iterable iterable4 = (List)iterable3;
            boolean bl4 = false;
            iterable3 = iterable4;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable4, (int)10));
            boolean bl5 = false;
            for (Object object2 : iterable3) {
                String string = (String)object2;
                Collection collection2 = collection;
                boolean bl6 = false;
                collection2.add(CookieKt.parseServerSetCookieHeader(string));
            }
            list = (List)collection;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static final List<Cookie> cookies(HttpMessageBuilder httpMessageBuilder) {
        List list;
        Intrinsics.checkNotNullParameter((Object)httpMessageBuilder, (String)"");
        List list2 = httpMessageBuilder.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            Iterable iterable = list2;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t : iterable2) {
                String string = (String)t;
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(CookieKt.parseServerSetCookieHeader(string));
            }
            list = (List)collection;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static final List<HeaderValue> cacheControl(HttpMessage httpMessage) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)httpMessage, (String)"");
                object = httpMessage.getHeaders().get(HttpHeaders.INSTANCE.getCacheControl());
                if (object == null) break block2;
                String string = object;
                boolean bl = false;
                List<HeaderValue> list = HttpHeaderValueParserKt.parseHeaderValue(string);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static final List<String> splitSetCookieHeader(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = StringsKt.indexOf$default((CharSequence)string, (char)',', (int)0, (boolean)false, (int)6, null);
        if (n == -1) {
            return CollectionsKt.listOf((Object)string);
        }
        List list = new ArrayList();
        int n2 = 0;
        int n3 = StringsKt.indexOf$default((CharSequence)string, (char)'=', (int)n, (boolean)false, (int)4, null);
        int n4 = StringsKt.indexOf$default((CharSequence)string, (char)';', (int)n, (boolean)false, (int)4, null);
        while (n2 < string.length() && n > 0) {
            int n5;
            block11: {
                block10: {
                    if (n3 < n) {
                        n3 = StringsKt.indexOf$default((CharSequence)string, (char)'=', (int)n, (boolean)false, (int)4, null);
                    }
                    n5 = StringsKt.indexOf$default((CharSequence)string, (char)',', (int)(n + 1), (boolean)false, (int)4, null);
                    while (true) {
                        boolean bl = 0 <= n5 ? n5 < n3 : false;
                        if (!bl) break;
                        n = n5;
                        n5 = StringsKt.indexOf$default((CharSequence)string, (char)',', (int)(n5 + 1), (boolean)false, (int)4, null);
                    }
                    if (n4 < n) {
                        n4 = StringsKt.indexOf$default((CharSequence)string, (char)';', (int)n, (boolean)false, (int)4, null);
                    }
                    if (n3 < 0) {
                        Collection collection = list;
                        String string2 = string.substring(n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                        collection.add(string2);
                        return list;
                    }
                    if (n4 == -1) break block10;
                    if (n4 <= n3) break block11;
                }
                Collection collection = list;
                String string3 = string.substring(n2, n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                collection.add(string3);
                n2 = n + 1;
            }
            n = n5;
        }
        if (n2 < string.length()) {
            Collection collection = list;
            String string4 = string.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
            collection.add(string4);
        }
        return list;
    }
}

