/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class SimpleRuleStore
extends ContextAwareBase
implements RuleStore {
    static String KLEENE_STAR = "*";
    HashMap<ElementSelector, Supplier<Action>> rules = new HashMap();
    List<String> transparentPathParts = new ArrayList<String>(2);
    Map<String, String> pathPartsMapForRenaming = new HashMap<String, String>(2);

    public SimpleRuleStore(Context context) {
        this.setContext(context);
    }

    @Override
    public void addTransparentPathPart(String string) {
        if (string == null) {
            throw new IllegalArgumentException("pathPart cannot be null");
        }
        if ((string = string.trim()).isEmpty()) {
            throw new IllegalArgumentException("pathPart cannot be empty or to consist of only spaces");
        }
        if (string.contains("/")) {
            throw new IllegalArgumentException("pathPart cannot contain '/', i.e. the forward slash character");
        }
        this.transparentPathParts.add(string);
    }

    @Override
    public void addPathPathMapping(String string, String string2) {
        this.pathPartsMapForRenaming.put(string, string2);
    }

    @Override
    public void addRule(ElementSelector elementSelector, Supplier<Action> supplier) {
        Supplier<Action> supplier2 = this.rules.get(elementSelector);
        if (supplier2 != null) {
            throw new IllegalStateException(elementSelector.toString() + " already has an associated action supplier");
        }
        this.rules.put(elementSelector, supplier);
    }

    @Override
    public void addRule(ElementSelector elementSelector, String string) {
        Action action = null;
        try {
            action = (Action)OptionHelper.instantiateByClassName(string, Action.class, this.context);
        }
        catch (Exception exception) {
            this.addError("Could not instantiate class [" + string + "]", exception);
        }
        if (action != null) {
            // empty if block
        }
    }

    @Override
    public Supplier<Action> matchActions(ElementPath elementPath) {
        Supplier<Action> supplier = this.internalMatchAction(elementPath);
        if (supplier != null) {
            return supplier;
        }
        return this.matchActionsWithoutTransparentPartsAndRenamedParts(elementPath);
    }

    private Supplier<Action> matchActionsWithoutTransparentPartsAndRenamedParts(ElementPath elementPath) {
        ElementPath elementPath2 = this.removeTransparentPathParts(elementPath);
        ElementPath elementPath3 = this.renamePathParts(elementPath2);
        return this.internalMatchAction(elementPath3);
    }

    private Supplier<Action> internalMatchAction(ElementPath elementPath) {
        Supplier<Action> supplier = this.fullPathMatch(elementPath);
        if (supplier != null) {
            return supplier;
        }
        supplier = this.suffixMatch(elementPath);
        if (supplier != null) {
            return supplier;
        }
        supplier = this.prefixMatch(elementPath);
        if (supplier != null) {
            return supplier;
        }
        supplier = this.middleMatch(elementPath);
        if (supplier != null) {
            return supplier;
        }
        return null;
    }

    ElementPath removeTransparentPathParts(ElementPath elementPath) {
        ArrayList<String> arrayList = new ArrayList<String>(elementPath.partList.size());
        for (String string : elementPath.partList) {
            boolean bl = this.transparentPathParts.stream().noneMatch(string2 -> string2.equalsIgnoreCase(string));
            if (!bl) continue;
            arrayList.add(string);
        }
        return new ElementPath(arrayList);
    }

    ElementPath renamePathParts(ElementPath elementPath) {
        ArrayList<String> arrayList = new ArrayList<String>(elementPath.partList.size());
        for (String string : elementPath.partList) {
            String string2 = this.pathPartsMapForRenaming.getOrDefault(string, string);
            arrayList.add(string2);
        }
        return new ElementPath(arrayList);
    }

    Supplier<Action> fullPathMatch(ElementPath elementPath) {
        for (ElementSelector elementSelector : this.rules.keySet()) {
            if (!elementSelector.fullPathMatch(elementPath)) continue;
            return this.rules.get(elementSelector);
        }
        return null;
    }

    Supplier<Action> suffixMatch(ElementPath elementPath) {
        int n = 0;
        ElementSelector elementSelector = null;
        for (ElementSelector elementSelector2 : this.rules.keySet()) {
            int n2;
            if (!this.isSuffixPattern(elementSelector2) || (n2 = elementSelector2.getTailMatchLength(elementPath)) <= n) continue;
            n = n2;
            elementSelector = elementSelector2;
        }
        if (elementSelector != null) {
            return this.rules.get(elementSelector);
        }
        return null;
    }

    private boolean isSuffixPattern(ElementSelector elementSelector) {
        return elementSelector.size() > 1 && elementSelector.get(0).equals(KLEENE_STAR);
    }

    Supplier<Action> prefixMatch(ElementPath elementPath) {
        int n = 0;
        ElementSelector elementSelector = null;
        for (ElementSelector elementSelector2 : this.rules.keySet()) {
            int n2;
            String string = elementSelector2.peekLast();
            if (!this.isKleeneStar(string) || (n2 = elementSelector2.getPrefixMatchLength(elementPath)) != elementSelector2.size() - 1 || n2 <= n) continue;
            n = n2;
            elementSelector = elementSelector2;
        }
        if (elementSelector != null) {
            return this.rules.get(elementSelector);
        }
        return null;
    }

    private boolean isKleeneStar(String string) {
        return KLEENE_STAR.equals(string);
    }

    Supplier<Action> middleMatch(ElementPath elementPath) {
        int n = 0;
        ElementSelector elementSelector = null;
        for (ElementSelector elementSelector2 : this.rules.keySet()) {
            String string = elementSelector2.peekLast();
            String string2 = null;
            if (elementSelector2.size() > 1) {
                string2 = elementSelector2.get(0);
            }
            if (!this.isKleeneStar(string) || !this.isKleeneStar(string2)) continue;
            List<String> list = elementSelector2.getCopyOfPartList();
            if (list.size() > 2) {
                list.remove(0);
                list.remove(list.size() - 1);
            }
            int n2 = 0;
            ElementSelector elementSelector3 = new ElementSelector(list);
            if (elementSelector3.isContainedIn(elementPath)) {
                n2 = elementSelector3.size();
            }
            if (n2 <= n) continue;
            n = n2;
            elementSelector = elementSelector2;
        }
        if (elementSelector != null) {
            return this.rules.get(elementSelector);
        }
        return null;
    }

    public String toString() {
        String string = "  ";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SimpleRuleStore ( ").append("rules = ").append(this.rules).append("  ").append(" )");
        return stringBuilder.toString();
    }
}

