/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.StringToObjectConverter;
import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.joran.util.beans.BeanUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AggregationAssessor
extends ContextAwareBase {
    protected final Class<?> objClass;
    protected final BeanDescription beanDescription;

    public AggregationAssessor(BeanDescriptionCache beanDescriptionCache, Class clazz) {
        this.objClass = clazz;
        this.beanDescription = beanDescriptionCache.getBeanDescription(clazz);
    }

    public AggregationType computeAggregationType(String string) {
        Object object;
        String string2 = StringUtil.capitalizeFirstLetter(string);
        Method method = this.findAdderMethod(string2);
        if (method != null) {
            object = this.computeRawAggregationType(method);
            switch (1.$SwitchMap$ch$qos$logback$core$util$AggregationType[((Enum)object).ordinal()]) {
                case 1: {
                    return AggregationType.NOT_FOUND;
                }
                case 2: {
                    return AggregationType.AS_BASIC_PROPERTY_COLLECTION;
                }
                case 3: {
                    return AggregationType.AS_COMPLEX_PROPERTY_COLLECTION;
                }
                case 4: 
                case 5: {
                    this.addError("Unexpected AggregationType " + String.valueOf(object));
                }
            }
        }
        if ((object = this.findSetterMethod(string)) != null) {
            return this.computeRawAggregationType((Method)object);
        }
        return AggregationType.NOT_FOUND;
    }

    public Method findAdderMethod(String string) {
        String string2 = BeanUtil.toLowerCamelCase(string);
        return this.beanDescription.getAdder(string2);
    }

    public Method findSetterMethod(String string) {
        String string2 = BeanUtil.toLowerCamelCase(string);
        return this.beanDescription.getSetter(string2);
    }

    private AggregationType computeRawAggregationType(Method method) {
        Class<?> clazz = this.getParameterClassForMethod(method);
        if (clazz == null) {
            return AggregationType.NOT_FOUND;
        }
        if (StringToObjectConverter.canBeBuiltFromSimpleString(clazz)) {
            return AggregationType.AS_BASIC_PROPERTY;
        }
        return AggregationType.AS_COMPLEX_PROPERTY;
    }

    private Class<?> getParameterClassForMethod(Method method) {
        if (method == null) {
            return null;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            return null;
        }
        return classArray[0];
    }

    public Class<?> getClassNameViaImplicitRules(String string, AggregationType aggregationType, DefaultNestedComponentRegistry defaultNestedComponentRegistry) {
        Class<?> clazz = defaultNestedComponentRegistry.findDefaultComponentType(this.objClass, string);
        if (clazz != null) {
            return clazz;
        }
        Method method = this.getRelevantMethod(string, aggregationType);
        if (method == null) {
            return null;
        }
        Class<?> clazz2 = this.getDefaultClassNameByAnnonation(string, method);
        if (clazz2 != null) {
            return clazz2;
        }
        return this.getByConcreteType(string, method);
    }

    <T extends Annotation> T getAnnotation(String string, Class<T> clazz, Method method) {
        if (method != null) {
            return method.getAnnotation(clazz);
        }
        return null;
    }

    Class<?> getDefaultClassNameByAnnonation(String string, Method method) {
        DefaultClass defaultClass = this.getAnnotation(string, DefaultClass.class, method);
        if (defaultClass != null) {
            return defaultClass.value();
        }
        return null;
    }

    Method getRelevantMethod(String string, AggregationType aggregationType) {
        Method method;
        if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY_COLLECTION) {
            method = this.findAdderMethod(string);
        } else if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY) {
            method = this.findSetterMethod(string);
        } else {
            throw new IllegalStateException(String.valueOf((Object)aggregationType) + " not allowed here");
        }
        return method;
    }

    Class<?> getByConcreteType(String string, Method method) {
        Class<?> clazz = this.getParameterClassForMethod(method);
        if (clazz == null) {
            return null;
        }
        boolean bl = this.isUnequivocallyInstantiable(clazz);
        if (bl) {
            return clazz;
        }
        return null;
    }

    private boolean isUnequivocallyInstantiable(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        try {
            Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return obj != null;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }
}

