/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ImcplicitActionDataForBasicProperty;
import ch.qos.logback.core.joran.action.ImplicitModelData;
import ch.qos.logback.core.joran.action.ImplicitModelDataForComplexProperty;
import ch.qos.logback.core.joran.spi.NoAutoStartUtil;
import ch.qos.logback.core.joran.util.PropertySetter;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;

public class ImplicitModelHandler
extends ModelHandlerBase {
    private final BeanDescriptionCache beanDescriptionCache;
    private ImplicitModelData implicitModelData;
    public static final String IGNORING_UNKNOWN_PROP = "Ignoring unknown property";
    boolean inError = false;

    public ImplicitModelHandler(Context context, BeanDescriptionCache beanDescriptionCache) {
        super(context);
        this.beanDescriptionCache = beanDescriptionCache;
    }

    protected Class<? extends ImplicitModel> getSupportedModelClass() {
        return ImplicitModel.class;
    }

    public static ImplicitModelHandler makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        BeanDescriptionCache beanDescriptionCache = modelInterpretationContext.getBeanDescriptionCache();
        return new ImplicitModelHandler(context, beanDescriptionCache);
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        ImplicitModel implicitModel = (ImplicitModel)model;
        if (modelInterpretationContext.isObjectStackEmpty()) {
            this.inError = true;
            return;
        }
        String string = implicitModel.getTag();
        Object object = modelInterpretationContext.peekObject();
        PropertySetter propertySetter = new PropertySetter(this.beanDescriptionCache, object);
        propertySetter.setContext(this.context);
        AggregationType aggregationType = propertySetter.computeAggregationType(string);
        switch (aggregationType) {
            case NOT_FOUND: {
                this.addWarn("Ignoring unknown property [" + string + "] in [" + object.getClass().getName() + "]");
                this.inError = true;
                implicitModel.markAsSkipped();
                return;
            }
            case AS_BASIC_PROPERTY: 
            case AS_BASIC_PROPERTY_COLLECTION: {
                ImcplicitActionDataForBasicProperty imcplicitActionDataForBasicProperty = new ImcplicitActionDataForBasicProperty(propertySetter, aggregationType, string);
                this.implicitModelData = imcplicitActionDataForBasicProperty;
                this.doBasicProperty(modelInterpretationContext, model, imcplicitActionDataForBasicProperty);
                return;
            }
            case AS_COMPLEX_PROPERTY_COLLECTION: 
            case AS_COMPLEX_PROPERTY: {
                ImplicitModelDataForComplexProperty implicitModelDataForComplexProperty = new ImplicitModelDataForComplexProperty(propertySetter, aggregationType, string);
                this.implicitModelData = implicitModelDataForComplexProperty;
                this.doComplex(modelInterpretationContext, implicitModel, implicitModelDataForComplexProperty);
                return;
            }
        }
        this.addError("PropertySetter.computeAggregationType returned " + String.valueOf((Object)aggregationType));
    }

    void doBasicProperty(ModelInterpretationContext modelInterpretationContext, Model model, ImcplicitActionDataForBasicProperty imcplicitActionDataForBasicProperty) {
        String string = modelInterpretationContext.subst(model.getBodyText());
        switch (imcplicitActionDataForBasicProperty.aggregationType) {
            case AS_BASIC_PROPERTY: {
                imcplicitActionDataForBasicProperty.parentBean.setProperty(imcplicitActionDataForBasicProperty.propertyName, string);
                break;
            }
            case AS_BASIC_PROPERTY_COLLECTION: {
                imcplicitActionDataForBasicProperty.parentBean.addBasicProperty(imcplicitActionDataForBasicProperty.propertyName, string);
                break;
            }
            default: {
                this.addError("Unexpected aggregationType " + String.valueOf((Object)imcplicitActionDataForBasicProperty.aggregationType));
            }
        }
    }

    public void doComplex(ModelInterpretationContext modelInterpretationContext, ComponentModel componentModel, ImplicitModelDataForComplexProperty implicitModelDataForComplexProperty) {
        String string = componentModel.getClassName();
        String string2 = modelInterpretationContext.subst(string);
        String string3 = modelInterpretationContext.getImport(string2);
        Class<?> clazz = null;
        try {
            Object object;
            if (!OptionHelper.isNullOrEmptyOrAllSpaces(string3)) {
                clazz = Loader.loadClass(string3, this.context);
            } else {
                object = implicitModelDataForComplexProperty.parentBean;
                clazz = ((PropertySetter)object).getClassNameViaImplicitRules(implicitModelDataForComplexProperty.propertyName, implicitModelDataForComplexProperty.getAggregationType(), modelInterpretationContext.getDefaultNestedComponentRegistry());
            }
            if (clazz == null) {
                implicitModelDataForComplexProperty.inError = true;
                object = "Could not find an appropriate class for property [" + componentModel.getTag() + "]";
                this.addError((String)object);
                return;
            }
            if (OptionHelper.isNullOrEmptyOrAllSpaces(string3)) {
                this.addInfo("Assuming default type [" + clazz.getName() + "] for [" + componentModel.getTag() + "] property");
            }
            implicitModelDataForComplexProperty.setNestedComplexProperty(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            if (implicitModelDataForComplexProperty.getNestedComplexProperty() instanceof ContextAware) {
                ((ContextAware)implicitModelDataForComplexProperty.getNestedComplexProperty()).setContext(this.context);
            }
            modelInterpretationContext.pushObject(implicitModelDataForComplexProperty.getNestedComplexProperty());
        }
        catch (Exception exception) {
            implicitModelDataForComplexProperty.inError = true;
            String string4 = "Could not create component [" + componentModel.getTag() + "] of type [" + string3 + "]";
            this.addError(string4, exception);
        }
    }

    @Override
    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model model) {
        if (this.inError) {
            return;
        }
        if (this.implicitModelData == null) {
            return;
        }
        if (this.implicitModelData.inError) {
            return;
        }
        if (this.implicitModelData instanceof ImplicitModelDataForComplexProperty) {
            this.postHandleComplex(modelInterpretationContext, model, (ImplicitModelDataForComplexProperty)this.implicitModelData);
        }
    }

    private void postHandleComplex(ModelInterpretationContext modelInterpretationContext, Model model, ImplicitModelDataForComplexProperty implicitModelDataForComplexProperty) {
        Object object;
        Object object2;
        PropertySetter propertySetter = new PropertySetter(this.beanDescriptionCache, implicitModelDataForComplexProperty.getNestedComplexProperty());
        propertySetter.setContext(this.context);
        if (propertySetter.computeAggregationType("parent") == AggregationType.AS_COMPLEX_PROPERTY) {
            propertySetter.setComplexProperty("parent", implicitModelDataForComplexProperty.parentBean.getObj());
        }
        if (NoAutoStartUtil.shouldBeStarted(object2 = implicitModelDataForComplexProperty.getNestedComplexProperty())) {
            ((LifeCycle)object2).start();
        }
        if ((object = modelInterpretationContext.peekObject()) != implicitModelDataForComplexProperty.getNestedComplexProperty()) {
            this.addError("The object on the top the of the stack is not the component pushed earlier.");
        } else {
            modelInterpretationContext.popObject();
            switch (implicitModelDataForComplexProperty.aggregationType) {
                case AS_COMPLEX_PROPERTY: {
                    implicitModelDataForComplexProperty.parentBean.setComplexProperty(model.getTag(), implicitModelDataForComplexProperty.getNestedComplexProperty());
                    break;
                }
                case AS_COMPLEX_PROPERTY_COLLECTION: {
                    implicitModelDataForComplexProperty.parentBean.addComplexProperty(model.getTag(), implicitModelDataForComplexProperty.getNestedComplexProperty());
                    break;
                }
                default: {
                    this.addError("Unexpected aggregationType " + String.valueOf((Object)implicitModelDataForComplexProperty.aggregationType));
                }
            }
        }
    }
}

