/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.ImportModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.OptionHelper;

public class ImportModelHandler
extends ModelHandlerBase {
    public ImportModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ImportModelHandler(context);
    }

    protected Class<ImportModel> getSupportedModelClass() {
        return ImportModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        ImportModel importModel = (ImportModel)model;
        String string = importModel.getClassName();
        if (OptionHelper.isNullOrEmptyOrAllSpaces(string)) {
            this.addWarn("Empty className not allowed");
            return;
        }
        String string2 = this.extractStem(string);
        if (string2 == null) {
            this.addWarn("[" + string + "] could not be imported due to incorrect format");
            return;
        }
        modelInterpretationContext.addImport(string2, string);
    }

    String extractStem(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        if (n + 1 == string.length()) {
            return null;
        }
        return string.substring(n + 1);
    }
}

