/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.GenericXMLConfigurator;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.function.Supplier;

public class IncludeModelHandler
extends ModelHandlerBase {
    boolean inError = false;
    private String attributeInUse;
    private boolean optional;

    public IncludeModelHandler(Context context) {
        super(context);
    }

    public static IncludeModelHandler makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new IncludeModelHandler(context);
    }

    protected Class<IncludeModel> getSupportedModelClass() {
        return IncludeModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        IncludeModel includeModel = (IncludeModel)model;
        this.optional = OptionHelper.toBoolean(includeModel.getOptional(), false);
        if (!this.checkAttributes(includeModel)) {
            this.inError = true;
            return;
        }
        InputStream inputStream = this.getInputStream(modelInterpretationContext, includeModel);
        if (inputStream == null) {
            this.inError = true;
            return;
        }
        SaxEventRecorder saxEventRecorder = null;
        try {
            saxEventRecorder = this.populateSaxEventRecorder(inputStream);
            List<SaxEvent> list = saxEventRecorder.getSaxEventList();
            if (list.isEmpty()) {
                this.addWarn("Empty sax event list");
                return;
            }
            Supplier<? extends GenericXMLConfigurator> supplier = modelInterpretationContext.getConfiguratorSupplier();
            if (supplier == null) {
                this.addError("null configurator supplier. Abandoning inclusion of [" + this.attributeInUse + "]");
                this.inError = true;
                return;
            }
            GenericXMLConfigurator genericXMLConfigurator = supplier.get();
            genericXMLConfigurator.getRuleStore().addPathPathMapping("included", "configuration");
            Model model2 = genericXMLConfigurator.buildModelFromSaxEventList(saxEventRecorder.getSaxEventList());
            if (model2 == null) {
                this.addError("Could not find valid configuration instructions. Exiting.");
                return;
            }
            includeModel.getSubModels().addAll(model2.getSubModels());
        }
        catch (JoranException joranException) {
            this.inError = true;
            this.addError("Error processing XML data in [" + this.attributeInUse + "]", joranException);
        }
    }

    public SaxEventRecorder populateSaxEventRecorder(InputStream inputStream) {
        SaxEventRecorder saxEventRecorder = new SaxEventRecorder(this.context);
        saxEventRecorder.recordEvents(inputStream);
        return saxEventRecorder;
    }

    private void trimHeadAndTail(List<SaxEvent> list) {
        SaxEvent saxEvent;
        if (list.size() == 0) {
            return;
        }
        SaxEvent saxEvent2 = list.get(0);
        if (saxEvent2 != null && saxEvent2.qName.equalsIgnoreCase("included")) {
            list.remove(0);
        }
        if ((saxEvent = list.get(list.size() - 1)) != null && saxEvent.qName.equalsIgnoreCase("included")) {
            list.remove(list.size() - 1);
        }
    }

    InputStream getInputStream(ModelInterpretationContext modelInterpretationContext, IncludeModel includeModel) {
        URL uRL = this.getInputURL(modelInterpretationContext, includeModel);
        if (uRL == null) {
            return null;
        }
        ConfigurationWatchListUtil.addToWatchList(this.context, uRL);
        return this.openURL(uRL);
    }

    InputStream openURL(URL uRL) {
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            this.optionalWarning("Failed to open [" + uRL.toString() + "]");
            return null;
        }
    }

    private boolean checkAttributes(IncludeModel includeModel) {
        String string = includeModel.getFile();
        String string2 = includeModel.getUrl();
        String string3 = includeModel.getResource();
        int n = 0;
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string)) {
            ++n;
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string2)) {
            ++n;
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string3)) {
            ++n;
        }
        if (n == 0) {
            this.addError("One of \"path\", \"resource\" or \"url\" attributes must be set.");
            return false;
        }
        if (n > 1) {
            this.addError("Only one of \"file\", \"url\" or \"resource\" attributes should be set.");
            return false;
        }
        if (n == 1) {
            return true;
        }
        throw new IllegalStateException("Count value [" + n + "] is not expected");
    }

    URL getInputURL(ModelInterpretationContext modelInterpretationContext, IncludeModel includeModel) {
        String string = includeModel.getFile();
        String string2 = includeModel.getUrl();
        String string3 = includeModel.getResource();
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string)) {
            this.attributeInUse = modelInterpretationContext.subst(string);
            return this.filePathAsURL(this.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string2)) {
            this.attributeInUse = modelInterpretationContext.subst(string2);
            return this.attributeToURL(this.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string3)) {
            this.attributeInUse = modelInterpretationContext.subst(string3);
            return this.resourceAsURL(this.attributeInUse);
        }
        throw new IllegalStateException("A URL stream should have been returned at this stage");
    }

    URL filePathAsURL(String string) {
        URI uRI = new File(string).toURI();
        try {
            return uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    URL attributeToURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = "URL [" + string + "] is not well formed.";
            this.addError(string2, malformedURLException);
            return null;
        }
    }

    URL resourceAsURL(String string) {
        URL uRL = Loader.getResourceBySelfClassLoader(string);
        if (uRL == null) {
            this.optionalWarning("Could not find resource corresponding to [" + string + "]");
            return null;
        }
        return uRL;
    }

    private void optionalWarning(String string) {
        if (!this.optional) {
            this.addWarn(string);
        }
    }
}

