/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class SyslogOutputStream
extends OutputStream {
    private static final int MAX_LEN = 1024;
    private InetAddress address;
    private DatagramSocket ds;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final int port;

    public SyslogOutputStream(String string, int n) {
        this.address = InetAddress.getByName(string);
        this.port = n;
        this.ds = new DatagramSocket();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.baos.write(byArray, n, n2);
    }

    @Override
    public void flush() {
        byte[] byArray = this.baos.toByteArray();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.address, this.port);
        if (this.baos.size() > 1024) {
            this.baos = new ByteArrayOutputStream();
        } else {
            this.baos.reset();
        }
        if (byArray.length == 0) {
            return;
        }
        if (this.ds != null) {
            this.ds.send(datagramPacket);
        }
    }

    @Override
    public void close() {
        this.address = null;
        this.ds = null;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void write(int n) {
        this.baos.write(n);
    }

    int getSendBufferSize() {
        return this.ds.getSendBufferSize();
    }
}

