/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.IdentityCompositeConverter;
import ch.qos.logback.core.pattern.ReplacingCompositeConverter;
import ch.qos.logback.core.pattern.parser.Compiler;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.FormattingNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.SimpleKeywordNode;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.parser.TokenStream;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Parser<E>
extends ContextAwareBase {
    public static final String MISSING_RIGHT_PARENTHESIS = "http://logback.qos.ch/codes.html#missingRightParenthesis";
    public static final Map<String, String> DEFAULT_COMPOSITE_CONVERTER_MAP = new HashMap<String, String>();
    public static final String REPLACE_CONVERTER_WORD = "replace";
    final List<Token> tokenList;
    int pointer = 0;

    Parser(TokenStream tokenStream) {
        this.tokenList = tokenStream.tokenize();
    }

    public Parser(String string) {
        this(string, new RegularEscapeUtil());
    }

    public Parser(String string, IEscapeUtil iEscapeUtil) {
        try {
            TokenStream tokenStream = new TokenStream(string, iEscapeUtil);
            this.tokenList = tokenStream.tokenize();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ScanException("Failed to initialize Parser", illegalArgumentException);
        }
    }

    public Converter<E> compile(Node node, Map<String, String> map) {
        Compiler compiler = new Compiler(node, map);
        compiler.setContext(this.context);
        return compiler.compile();
    }

    public Node parse() {
        return this.E();
    }

    Node E() {
        Node node = this.T();
        if (node == null) {
            return null;
        }
        Node node2 = this.Eopt();
        if (node2 != null) {
            node.setNext(node2);
        }
        return node;
    }

    Node Eopt() {
        Token token = this.getCurentToken();
        if (token == null) {
            return null;
        }
        return this.E();
    }

    Node T() {
        Token token = this.getCurentToken();
        this.expectNotNull(token, "a LITERAL or '%'");
        switch (token.getType()) {
            case 1000: {
                this.advanceTokenPointer();
                return new Node(0, token.getValue());
            }
            case 37: {
                FormattingNode formattingNode;
                this.advanceTokenPointer();
                Token token2 = this.getCurentToken();
                this.expectNotNull(token2, "a FORMAT_MODIFIER, SIMPLE_KEYWORD or COMPOUND_KEYWORD");
                if (token2.getType() == 1002) {
                    FormatInfo formatInfo = FormatInfo.valueOf(token2.getValue());
                    this.advanceTokenPointer();
                    formattingNode = this.C();
                    formattingNode.setFormatInfo(formatInfo);
                } else {
                    formattingNode = this.C();
                }
                return formattingNode;
            }
        }
        return null;
    }

    FormattingNode C() {
        Token token = this.getCurentToken();
        this.expectNotNull(token, "a LEFT_PARENTHESIS or KEYWORD");
        int n = token.getType();
        switch (n) {
            case 1004: {
                return this.SINGLE();
            }
            case 1005: {
                this.advanceTokenPointer();
                return this.COMPOSITE(token.getValue().toString());
            }
        }
        throw new IllegalStateException("Unexpected token " + String.valueOf(token));
    }

    FormattingNode SINGLE() {
        Token token = this.getNextToken();
        SimpleKeywordNode simpleKeywordNode = new SimpleKeywordNode(token.getValue());
        Token token2 = this.getCurentToken();
        if (token2 != null && token2.getType() == 1006) {
            List<String> list = token2.getOptionsList();
            simpleKeywordNode.setOptions(list);
            this.advanceTokenPointer();
        }
        return simpleKeywordNode;
    }

    FormattingNode COMPOSITE(String string) {
        CompositeNode compositeNode = new CompositeNode(string);
        Node node = this.E();
        compositeNode.setChildNode(node);
        Token token = this.getNextToken();
        if (token == null || token.getType() != 41) {
            String string2 = "Expecting RIGHT_PARENTHESIS token but got " + String.valueOf(token);
            this.addError(string2);
            this.addError("See also http://logback.qos.ch/codes.html#missingRightParenthesis");
            throw new ScanException(string2);
        }
        Token token2 = this.getCurentToken();
        if (token2 != null && token2.getType() == 1006) {
            List<String> list = token2.getOptionsList();
            compositeNode.setOptions(list);
            this.advanceTokenPointer();
        }
        return compositeNode;
    }

    Token getNextToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer++);
        }
        return null;
    }

    Token getCurentToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer);
        }
        return null;
    }

    void advanceTokenPointer() {
        ++this.pointer;
    }

    void expectNotNull(Token token, String string) {
        if (token == null) {
            throw new IllegalStateException("All tokens consumed but was expecting " + string);
        }
    }

    static {
        DEFAULT_COMPOSITE_CONVERTER_MAP.put(Token.BARE_COMPOSITE_KEYWORD_TOKEN.getValue().toString(), IdentityCompositeConverter.class.getName());
        DEFAULT_COMPOSITE_CONVERTER_MAP.put(REPLACE_CONVERTER_WORD, ReplacingCompositeConverter.class.getName());
    }
}

