/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.util;

import ch.qos.logback.core.pattern.util.IEscapeUtil;

public class RegularEscapeUtil
implements IEscapeUtil {
    @Override
    public void escape(String string, StringBuffer stringBuffer, char c, int n) {
        if (string.indexOf(c) >= 0) {
            stringBuffer.append(c);
        } else {
            switch (c) {
                case '_': {
                    break;
                }
                case '\\': {
                    stringBuffer.append(c);
                    break;
                }
                case 't': {
                    stringBuffer.append('\t');
                    break;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    break;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    break;
                }
                default: {
                    String string2 = this.formatEscapeCharsForListing(string);
                    throw new IllegalArgumentException("Illegal char '" + c + " at column " + n + ". Only \\\\, \\_" + string2 + ", \\t, \\n, \\r combinations are allowed as escape characters.");
                }
            }
        }
    }

    String formatEscapeCharsForListing(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(", \\").append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static String basicEscape(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92 && n2 < n) {
                if ((n3 = string.charAt(n2++)) == 110) {
                    n3 = 10;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 102) {
                    n3 = 12;
                } else if (n3 == 8) {
                    n3 = 8;
                } else if (n3 == 34) {
                    n3 = 34;
                } else if (n3 == 39) {
                    n3 = 39;
                } else if (n3 == 92) {
                    n3 = 92;
                }
            }
            stringBuilder.append((char)n3);
        }
        return stringBuilder.toString();
    }
}

