/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RolloverFailure;
import java.io.File;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileStoreUtil {
    static final String PATH_CLASS_STR = "java.nio.file.Path";
    static final String FILES_CLASS_STR = "java.nio.file.Files";

    public static boolean areOnSameFileStore(File file, File file2) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File [" + String.valueOf(file) + "] does not exist.");
        }
        if (!file2.exists()) {
            throw new IllegalArgumentException("File [" + String.valueOf(file2) + "] does not exist.");
        }
        try {
            Path path = file.toPath();
            Path path2 = file2.toPath();
            FileStore fileStore = Files.getFileStore(path);
            FileStore fileStore2 = Files.getFileStore(path2);
            return fileStore.equals(fileStore2);
        }
        catch (Exception exception) {
            throw new RolloverFailure("Failed to check file store equality for [" + String.valueOf(file) + "] and [" + String.valueOf(file2) + "]", exception);
        }
    }
}

