/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.SiftModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.sift.AppenderFactoryUsingSiftModel;
import ch.qos.logback.core.sift.SiftingAppenderBase;
import java.util.stream.Stream;

public class SiftModelHandler
extends ModelHandlerBase {
    static final String ONE_AND_ONLY_ONE_URL = "http://logback.qos.ch/codes.html#1andOnly1";

    public SiftModelHandler(Context context) {
        super(context);
    }

    public static SiftModelHandler makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new SiftModelHandler(context);
    }

    protected Class<SiftModel> getSupportedModelClass() {
        return SiftModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        SiftModel siftModel = (SiftModel)model;
        siftModel.markAsSkipped();
        long l = this.computeAppenderModelCount(siftModel);
        if (l == 0L) {
            String string = "No nested appenders found within the <sift> element in SiftingAppender.";
            this.addError(string);
            return;
        }
        if (l > 1L) {
            String string = "Only and only one appender can be nested the <sift> element in SiftingAppender. See also http://logback.qos.ch/codes.html#1andOnly1";
            this.addError(string);
            return;
        }
        Object object = modelInterpretationContext.peekObject();
        if (object instanceof SiftingAppenderBase) {
            SiftingAppenderBase siftingAppenderBase = (SiftingAppenderBase)object;
            String string = siftingAppenderBase.getDiscriminatorKey();
            AppenderFactoryUsingSiftModel appenderFactoryUsingSiftModel = new AppenderFactoryUsingSiftModel(modelInterpretationContext, siftModel, string);
            siftingAppenderBase.setAppenderFactory(appenderFactoryUsingSiftModel);
        } else {
            this.addError("Unexpected object " + String.valueOf(object));
        }
    }

    private long computeAppenderModelCount(SiftModel siftModel) {
        Stream stream = siftModel.getSubModels().stream();
        long l = stream.filter(model -> model instanceof AppenderModel).count();
        return l;
    }
}

