/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;

public class CachingDateFormatter {
    final DateTimeFormatter dtf;
    final ZoneId zoneId;
    final AtomicReference<CacheTuple> atomicReference;

    public CachingDateFormatter(String string) {
        this(string, null);
    }

    public CachingDateFormatter(String string, ZoneId zoneId) {
        this(string, zoneId, null);
    }

    public CachingDateFormatter(String string, ZoneId zoneId, Locale locale) {
        this.zoneId = zoneId == null ? ZoneId.systemDefault() : zoneId;
        Locale locale2 = locale != null ? locale : Locale.getDefault();
        this.dtf = DateTimeFormatter.ofPattern(string).withZone(this.zoneId).withLocale(locale2);
        CacheTuple cacheTuple = new CacheTuple(-1L, null);
        this.atomicReference = new AtomicReference<CacheTuple>(cacheTuple);
    }

    public final String format(long l) {
        CacheTuple cacheTuple;
        CacheTuple cacheTuple2 = cacheTuple = this.atomicReference.get();
        if (l != cacheTuple.lastTimestamp) {
            Instant instant = Instant.ofEpochMilli(l);
            String string = this.dtf.format(instant);
            cacheTuple = new CacheTuple(l, string);
            this.atomicReference.compareAndSet(cacheTuple2, cacheTuple);
        }
        return cacheTuple.cachedStr;
    }

    static class CacheTuple {
        final long lastTimestamp;
        final String cachedStr;

        public CacheTuple(long l, String string) {
            this.lastTimestamp = l;
            this.cachedStr = string;
        }
    }
}

