/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.Loader;
import java.lang.module.ModuleDescriptor;
import java.util.Optional;

public class EnvUtil {
    private EnvUtil() {
    }

    public static String logbackVersion() {
        String string = EnvUtil.logbackVersionByModule();
        if (string != null) {
            return string;
        }
        Package package_ = EnvUtil.class.getPackage();
        if (package_ == null) {
            return null;
        }
        return package_.getImplementationVersion();
    }

    private static String logbackVersionByModule() {
        Module module = EnvUtil.class.getModule();
        if (module == null) {
            return null;
        }
        ModuleDescriptor moduleDescriptor = module.getDescriptor();
        if (moduleDescriptor == null) {
            return null;
        }
        Optional<String> optional = moduleDescriptor.rawVersion();
        return optional.orElse(null);
    }

    public static int getJDKVersion(String string) {
        int n = 0;
        for (char c : string.toCharArray()) {
            if (Character.isDigit(c)) {
                n = n * 10 + (c - 48);
                continue;
            }
            if (n != 1) break;
            n = 0;
        }
        return n;
    }

    private static boolean isJDK_N_OrHigher(int n) {
        String string = System.getProperty("java.version", "");
        if (string.isEmpty()) {
            return false;
        }
        int n2 = EnvUtil.getJDKVersion(string);
        return n2 > 0 && n <= n2;
    }

    public static boolean isJDK5() {
        return EnvUtil.isJDK_N_OrHigher(5);
    }

    public static boolean isJDK6OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(6);
    }

    public static boolean isJDK7OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(7);
    }

    public static boolean isJDK16OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(16);
    }

    public static boolean isJDK18OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(18);
    }

    public static boolean isJDK21OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(21);
    }

    public static boolean isJaninoAvailable() {
        ClassLoader classLoader = EnvUtil.class.getClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass("org.codehaus.janino.ScriptEvaluator");
            return clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.startsWith("Windows");
    }

    public static boolean isClassAvailable(Class clazz, String string) {
        ClassLoader classLoader = Loader.getClassLoaderOfClass(clazz);
        try {
            Class<?> clazz2 = classLoader.loadClass(string);
            return clazz2 != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

