/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.subst.NodeToStringTransformer;
import ch.qos.logback.core.util.DynamicClassLoadingException;
import ch.qos.logback.core.util.IncompatibleClassException;
import ch.qos.logback.core.util.Loader;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class OptionHelper {
    static final String DELIM_START = "${";
    static final char DELIM_STOP = '}';
    static final String DELIM_DEFAULT = ":-";
    static final int DELIM_START_LEN = 2;
    static final int DELIM_STOP_LEN = 1;
    static final int DELIM_DEFAULT_LEN = 2;
    static final String _IS_UNDEFINED = "_IS_UNDEFINED";

    public static Object instantiateByClassName(String string, Class<?> clazz, Context context) {
        ClassLoader classLoader = Loader.getClassLoaderOfObject(context);
        return OptionHelper.instantiateByClassName(string, clazz, classLoader);
    }

    public static Object instantiateByClassNameAndParameter(String string, Class<?> clazz, Context context, Class<?> clazz2, Object object) {
        ClassLoader classLoader = Loader.getClassLoaderOfObject(context);
        return OptionHelper.instantiateByClassNameAndParameter(string, clazz, classLoader, clazz2, object);
    }

    public static Object instantiateByClassName(String string, Class<?> clazz, ClassLoader classLoader) {
        return OptionHelper.instantiateByClassNameAndParameter(string, clazz, classLoader, null, null);
    }

    public static Object instantiateByClassNameAndParameter(String string, Class<?> clazz, ClassLoader classLoader, Class<?> clazz2, Object object) {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            Class<?> clazz3 = null;
            clazz3 = classLoader.loadClass(string);
            if (!clazz.isAssignableFrom(clazz3)) {
                throw new IncompatibleClassException(clazz, clazz3);
            }
            if (clazz2 == null) {
                return clazz3.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Constructor<?> constructor = clazz3.getConstructor(clazz2);
            return constructor.newInstance(object);
        }
        catch (IncompatibleClassException incompatibleClassException) {
            throw incompatibleClassException;
        }
        catch (Throwable throwable) {
            throw new DynamicClassLoadingException("Failed to instantiate type " + string, throwable);
        }
    }

    public static String substVars(String string, PropertyContainer propertyContainer) {
        return OptionHelper.substVars(string, propertyContainer, null);
    }

    public static String substVars(String string, PropertyContainer propertyContainer, PropertyContainer propertyContainer2) {
        return NodeToStringTransformer.substituteVariable(string, propertyContainer, propertyContainer2);
    }

    public static String propertyLookup(String string, PropertyContainer propertyContainer, PropertyContainer propertyContainer2) {
        String string2 = null;
        string2 = propertyContainer.getProperty(string);
        if (string2 == null && propertyContainer2 != null) {
            string2 = propertyContainer2.getProperty(string);
        }
        if (string2 == null) {
            string2 = OptionHelper.getSystemProperty(string, null);
        }
        if (string2 == null) {
            string2 = OptionHelper.getEnv(string);
        }
        return string2;
    }

    public static String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    public static String getEnv(String string) {
        try {
            return System.getenv(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static void setSystemProperties(ContextAware contextAware, Properties properties) {
        for (Object object : properties.keySet()) {
            String string = (String)object;
            String string2 = properties.getProperty(string);
            OptionHelper.setSystemProperty(contextAware, string, string2);
        }
    }

    public static void setSystemProperty(ContextAware contextAware, String string, String string2) {
        try {
            System.setProperty(string, string2);
        }
        catch (SecurityException securityException) {
            contextAware.addError("Failed to set system property [" + string + "]", securityException);
        }
    }

    public static Properties getSystemProperties() {
        try {
            return System.getProperties();
        }
        catch (SecurityException securityException) {
            return new Properties();
        }
    }

    public static String[] extractDefaultReplacement(String string) {
        String[] stringArray = new String[2];
        if (string == null) {
            return stringArray;
        }
        stringArray[0] = string;
        int n = string.indexOf(DELIM_DEFAULT);
        if (n != -1) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 2);
        }
        return stringArray;
    }

    public static boolean toBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        String string2 = string.trim();
        if ("true".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return false;
        }
        return bl;
    }

    public static boolean isEmpty(String string) {
        return OptionHelper.isNullOrEmptyOrAllSpaces(string);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isNullOrEmptyOrAllSpaces(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static final boolean isNullOrEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static final boolean isNotEmtpy(Object[] objectArray) {
        return !OptionHelper.isNullOrEmpty(objectArray);
    }
}

