/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CombinedHttpHeaders
extends DefaultHttpHeaders {
    @Deprecated
    public CombinedHttpHeaders(boolean bl) {
        super(new CombinedHttpHeadersImpl((HashingStrategy<CharSequence>)AsciiString.CASE_INSENSITIVE_HASHER, CombinedHttpHeaders.valueConverter(), CombinedHttpHeaders.nameValidator(bl), CombinedHttpHeaders.valueValidator(bl)));
    }

    CombinedHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
        super(new CombinedHttpHeadersImpl((HashingStrategy<CharSequence>)AsciiString.CASE_INSENSITIVE_HASHER, CombinedHttpHeaders.valueConverter(), (DefaultHeaders.NameValidator<CharSequence>)((DefaultHeaders.NameValidator)ObjectUtil.checkNotNull(nameValidator, (String)"nameValidator")), (DefaultHeaders.ValueValidator<CharSequence>)((DefaultHeaders.ValueValidator)ObjectUtil.checkNotNull(valueValidator, (String)"valueValidator"))));
    }

    CombinedHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator, int n) {
        super(new CombinedHttpHeadersImpl((HashingStrategy<CharSequence>)AsciiString.CASE_INSENSITIVE_HASHER, CombinedHttpHeaders.valueConverter(), (DefaultHeaders.NameValidator<CharSequence>)((DefaultHeaders.NameValidator)ObjectUtil.checkNotNull(nameValidator, (String)"nameValidator")), (DefaultHeaders.ValueValidator<CharSequence>)((DefaultHeaders.ValueValidator)ObjectUtil.checkNotNull(valueValidator, (String)"valueValidator")), n));
    }

    @Override
    public boolean containsValue(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        return super.containsValue(charSequence, StringUtil.trimOws((CharSequence)charSequence2), bl);
    }

    private static final class CombinedHttpHeadersImpl
    extends DefaultHeaders<CharSequence, CharSequence, CombinedHttpHeadersImpl> {
        private static final int VALUE_LENGTH_ESTIMATE = 10;
        private CsvValueEscaper<Object> objectEscaper;
        private CsvValueEscaper<CharSequence> charSequenceEscaper;

        private CsvValueEscaper<Object> objectEscaper() {
            if (this.objectEscaper == null) {
                this.objectEscaper = new CsvValueEscaper<Object>(){

                    @Override
                    public CharSequence escape(CharSequence charSequence, Object object) {
                        CharSequence charSequence2;
                        try {
                            charSequence2 = (CharSequence)CombinedHttpHeadersImpl.this.valueConverter().convertObject(object);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new IllegalArgumentException("Failed to convert object value for header '" + charSequence + '\'', illegalArgumentException);
                        }
                        return StringUtil.escapeCsv((CharSequence)charSequence2, (boolean)true);
                    }
                };
            }
            return this.objectEscaper;
        }

        private CsvValueEscaper<CharSequence> charSequenceEscaper() {
            if (this.charSequenceEscaper == null) {
                this.charSequenceEscaper = new CsvValueEscaper<CharSequence>(){

                    @Override
                    public CharSequence escape(CharSequence charSequence, CharSequence charSequence2) {
                        return StringUtil.escapeCsv((CharSequence)charSequence2, (boolean)true);
                    }
                };
            }
            return this.charSequenceEscaper;
        }

        CombinedHttpHeadersImpl(HashingStrategy<CharSequence> hashingStrategy, ValueConverter<CharSequence> valueConverter, DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
            this(hashingStrategy, valueConverter, nameValidator, valueValidator, 16);
        }

        CombinedHttpHeadersImpl(HashingStrategy<CharSequence> hashingStrategy, ValueConverter<CharSequence> valueConverter, DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator, int n) {
            super(hashingStrategy, valueConverter, nameValidator, n, valueValidator);
        }

        public Iterator<CharSequence> valueIterator(CharSequence charSequence) {
            Iterator iterator = super.valueIterator((Object)charSequence);
            if (!iterator.hasNext() || CombinedHttpHeadersImpl.cannotBeCombined(charSequence)) {
                return iterator;
            }
            Iterator<CharSequence> iterator2 = StringUtil.unescapeCsvFields((CharSequence)((CharSequence)iterator.next())).iterator();
            if (iterator.hasNext()) {
                throw new IllegalStateException("CombinedHttpHeaders should only have one value");
            }
            return iterator2;
        }

        public List<CharSequence> getAll(CharSequence charSequence) {
            List list = super.getAll((Object)charSequence);
            if (list.isEmpty() || CombinedHttpHeadersImpl.cannotBeCombined(charSequence)) {
                return list;
            }
            if (list.size() != 1) {
                throw new IllegalStateException("CombinedHttpHeaders should only have one value");
            }
            return StringUtil.unescapeCsvFields((CharSequence)((CharSequence)list.get(0)));
        }

        public CombinedHttpHeadersImpl add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            if (headers == this) {
                throw new IllegalArgumentException("can't add to itself.");
            }
            if (headers instanceof CombinedHttpHeadersImpl) {
                if (this.isEmpty()) {
                    this.addImpl(headers);
                } else {
                    for (Map.Entry entry : headers) {
                        this.addEscapedValue((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                    }
                }
            } else {
                for (Map.Entry entry : headers) {
                    this.add((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
            }
            return this;
        }

        public CombinedHttpHeadersImpl set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            if (headers == this) {
                return this;
            }
            this.clear();
            return this.add(headers);
        }

        public CombinedHttpHeadersImpl setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            if (headers == this) {
                return this;
            }
            for (CharSequence charSequence : headers.names()) {
                this.remove(charSequence);
            }
            return this.add(headers);
        }

        public CombinedHttpHeadersImpl add(CharSequence charSequence, CharSequence charSequence2) {
            return this.addEscapedValue(charSequence, this.charSequenceEscaper().escape(charSequence, charSequence2));
        }

        public CombinedHttpHeadersImpl add(CharSequence charSequence, CharSequence ... charSequenceArray) {
            return this.addEscapedValue(charSequence, CombinedHttpHeadersImpl.commaSeparate(charSequence, this.charSequenceEscaper(), charSequenceArray));
        }

        public CombinedHttpHeadersImpl add(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
            return this.addEscapedValue(charSequence, CombinedHttpHeadersImpl.commaSeparate(charSequence, this.charSequenceEscaper(), iterable));
        }

        public CombinedHttpHeadersImpl addObject(CharSequence charSequence, Object object) {
            return this.addEscapedValue(charSequence, CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), object));
        }

        public CombinedHttpHeadersImpl addObject(CharSequence charSequence, Iterable<?> iterable) {
            return this.addEscapedValue(charSequence, CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), iterable));
        }

        public CombinedHttpHeadersImpl addObject(CharSequence charSequence, Object ... objectArray) {
            return this.addEscapedValue(charSequence, CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), objectArray));
        }

        public CombinedHttpHeadersImpl set(CharSequence charSequence, CharSequence ... charSequenceArray) {
            this.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(charSequence, this.charSequenceEscaper(), charSequenceArray));
            return this;
        }

        public CombinedHttpHeadersImpl set(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
            this.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(charSequence, this.charSequenceEscaper(), iterable));
            return this;
        }

        public CombinedHttpHeadersImpl setObject(CharSequence charSequence, Object object) {
            this.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), object));
            return this;
        }

        public CombinedHttpHeadersImpl setObject(CharSequence charSequence, Object ... objectArray) {
            this.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), objectArray));
            return this;
        }

        public CombinedHttpHeadersImpl setObject(CharSequence charSequence, Iterable<?> iterable) {
            this.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), iterable));
            return this;
        }

        private static boolean cannotBeCombined(CharSequence charSequence) {
            return HttpHeaderNames.SET_COOKIE.contentEqualsIgnoreCase(charSequence);
        }

        private CombinedHttpHeadersImpl addEscapedValue(CharSequence charSequence, CharSequence charSequence2) {
            CharSequence charSequence3 = (CharSequence)this.get(charSequence);
            if (charSequence3 == null || CombinedHttpHeadersImpl.cannotBeCombined(charSequence)) {
                super.add((Object)charSequence, (Object)charSequence2);
            } else {
                this.set(charSequence, CombinedHttpHeadersImpl.commaSeparateEscapedValues(charSequence3, charSequence2));
            }
            return this;
        }

        private static <T> CharSequence commaSeparate(CharSequence charSequence, CsvValueEscaper<T> csvValueEscaper, T ... TArray) {
            StringBuilder stringBuilder = new StringBuilder(TArray.length * 10);
            if (TArray.length > 0) {
                int n = TArray.length - 1;
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(csvValueEscaper.escape(charSequence, TArray[i])).append(',');
                }
                stringBuilder.append(csvValueEscaper.escape(charSequence, TArray[n]));
            }
            return stringBuilder;
        }

        private static <T> CharSequence commaSeparate(CharSequence charSequence, CsvValueEscaper<T> csvValueEscaper, Iterable<? extends T> iterable) {
            StringBuilder stringBuilder = iterable instanceof Collection ? new StringBuilder(((Collection)iterable).size() * 10) : new StringBuilder();
            Iterator<T> iterator = iterable.iterator();
            if (iterator.hasNext()) {
                T t = iterator.next();
                while (iterator.hasNext()) {
                    stringBuilder.append(csvValueEscaper.escape(charSequence, t)).append(',');
                    t = iterator.next();
                }
                stringBuilder.append(csvValueEscaper.escape(charSequence, t));
            }
            return stringBuilder;
        }

        private static CharSequence commaSeparateEscapedValues(CharSequence charSequence, CharSequence charSequence2) {
            return new StringBuilder(charSequence.length() + 1 + charSequence2.length()).append(charSequence).append(',').append(charSequence2);
        }

        private static interface CsvValueEscaper<T> {
            public CharSequence escape(CharSequence var1, T var2);
        }
    }
}

