/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.AsciiString;

public final class HttpHeaderValidationUtil {
    private HttpHeaderValidationUtil() {
    }

    public static boolean isConnectionHeader(CharSequence charSequence, boolean bl) {
        int n = charSequence.length();
        switch (n) {
            case 2: {
                return bl ? false : AsciiString.contentEqualsIgnoreCase((CharSequence)charSequence, (CharSequence)HttpHeaderNames.TE);
            }
            case 7: {
                return AsciiString.contentEqualsIgnoreCase((CharSequence)charSequence, (CharSequence)HttpHeaderNames.UPGRADE);
            }
            case 10: {
                return AsciiString.contentEqualsIgnoreCase((CharSequence)charSequence, (CharSequence)HttpHeaderNames.CONNECTION) || AsciiString.contentEqualsIgnoreCase((CharSequence)charSequence, (CharSequence)HttpHeaderNames.KEEP_ALIVE);
            }
            case 16: {
                return AsciiString.contentEqualsIgnoreCase((CharSequence)charSequence, (CharSequence)HttpHeaderNames.PROXY_CONNECTION);
            }
            case 17: {
                return AsciiString.contentEqualsIgnoreCase((CharSequence)charSequence, (CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            }
        }
        return false;
    }

    public static boolean isTeNotTrailers(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence.length() == 2) {
            return AsciiString.contentEqualsIgnoreCase((CharSequence)charSequence, (CharSequence)HttpHeaderNames.TE) && !AsciiString.contentEqualsIgnoreCase((CharSequence)charSequence2, (CharSequence)HttpHeaderValues.TRAILERS);
        }
        return false;
    }

    public static int validateValidHeaderValue(CharSequence charSequence) {
        int n = charSequence.length();
        if (n == 0) {
            return -1;
        }
        if (charSequence instanceof AsciiString) {
            return HttpHeaderValidationUtil.verifyValidHeaderValueAsciiString((AsciiString)charSequence);
        }
        return HttpHeaderValidationUtil.verifyValidHeaderValueCharSequence(charSequence);
    }

    private static int verifyValidHeaderValueAsciiString(AsciiString asciiString) {
        int n;
        byte[] byArray = asciiString.array();
        int n2 = byArray[n = asciiString.arrayOffset()] & 0xFF;
        if (n2 < 33 || n2 == 127) {
            return 0;
        }
        int n3 = n + asciiString.length();
        for (int i = n + 1; i < n3; ++i) {
            n2 = byArray[i] & 0xFF;
            if ((n2 >= 32 || n2 == 9) && n2 != 127) continue;
            return i - n;
        }
        return -1;
    }

    private static int verifyValidHeaderValueCharSequence(CharSequence charSequence) {
        char c = charSequence.charAt(0);
        if (c < '!' || c == '\u007f') {
            return 0;
        }
        int n = charSequence.length();
        for (int i = 1; i < n; ++i) {
            c = charSequence.charAt(i);
            if ((c >= ' ' || c == '\t') && c != '\u007f') continue;
            return i;
        }
        return -1;
    }

    public static int validateToken(CharSequence charSequence) {
        return HttpUtil.validateToken(charSequence);
    }
}

