/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteOrder;
import java.util.List;

public class WebSocket08FrameEncoder
extends MessageToMessageEncoder<WebSocketFrame>
implements WebSocketFrameEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocket08FrameEncoder.class);
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private static final int GATHERING_WRITE_THRESHOLD = 1024;
    private final boolean maskPayload;

    public WebSocket08FrameEncoder(boolean bl) {
        this.maskPayload = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        int n;
        ByteBuf byteBuf = webSocketFrame.content();
        if (webSocketFrame instanceof TextWebSocketFrame) {
            n = 1;
        } else if (webSocketFrame instanceof PingWebSocketFrame) {
            n = 9;
        } else if (webSocketFrame instanceof PongWebSocketFrame) {
            n = 10;
        } else if (webSocketFrame instanceof CloseWebSocketFrame) {
            n = 8;
        } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
            n = 2;
        } else if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            n = 0;
        } else {
            throw new UnsupportedOperationException("Cannot encode frame of type: " + ((Object)((Object)webSocketFrame)).getClass().getName());
        }
        int n2 = byteBuf.readableBytes();
        if (logger.isTraceEnabled()) {
            logger.trace("Encoding WebSocket Frame opCode={} length={}", (Object)((byte)n), (Object)n2);
        }
        int n3 = 0;
        if (webSocketFrame.isFinalFragment()) {
            n3 |= 0x80;
        }
        n3 |= webSocketFrame.rsv() % 8 << 4;
        n3 |= n % 128;
        if (n == 9 && n2 > 125) {
            throw new TooLongFrameException("invalid payload for PING (payload length must be <= 125, was " + n2);
        }
        boolean bl = true;
        ByteBuf byteBuf2 = null;
        try {
            int n4;
            int n5;
            int n6 = n5 = this.maskPayload ? 4 : 0;
            if (n2 <= 125) {
                n4 = 2 + n5 + n2;
                byteBuf2 = channelHandlerContext.alloc().buffer(n4);
                byteBuf2.writeByte(n3);
                byte by = this.maskPayload ? (byte)(0x80 | (byte)n2) : (byte)n2;
                byteBuf2.writeByte((int)by);
            } else if (n2 <= 65535) {
                n4 = 4 + n5;
                if (this.maskPayload || n2 <= 1024) {
                    n4 += n2;
                }
                byteBuf2 = channelHandlerContext.alloc().buffer(n4);
                byteBuf2.writeByte(n3);
                byteBuf2.writeByte(this.maskPayload ? 254 : 126);
                byteBuf2.writeByte(n2 >>> 8 & 0xFF);
                byteBuf2.writeByte(n2 & 0xFF);
            } else {
                n4 = 10 + n5;
                if (this.maskPayload) {
                    n4 += n2;
                }
                byteBuf2 = channelHandlerContext.alloc().buffer(n4);
                byteBuf2.writeByte(n3);
                byteBuf2.writeByte(this.maskPayload ? 255 : 127);
                byteBuf2.writeLong((long)n2);
            }
            if (this.maskPayload) {
                n4 = PlatformDependent.threadLocalRandom().nextInt(Integer.MAX_VALUE);
                byteBuf2.writeInt(n4);
                if (byteBuf.isReadable()) {
                    ByteOrder byteOrder = byteBuf.order();
                    ByteOrder byteOrder2 = byteBuf2.order();
                    int n7 = byteBuf.readerIndex();
                    int n8 = byteBuf.writerIndex();
                    if (byteOrder == byteOrder2) {
                        long l = (long)n4 & 0xFFFFFFFFL;
                        l |= l << 32;
                        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            l = Long.reverseBytes(l);
                        }
                        int n9 = n8 - 7;
                        while (n7 < n9) {
                            byteBuf2.writeLong(byteBuf.getLong(n7) ^ l);
                            n7 += 8;
                        }
                        if (n7 < n8 - 3) {
                            byteBuf2.writeInt(byteBuf.getInt(n7) ^ (int)l);
                            n7 += 4;
                        }
                    }
                    int n10 = 0;
                    while (n7 < n8) {
                        byte by = byteBuf.getByte(n7);
                        byteBuf2.writeByte(by ^ WebSocketUtil.byteAtIndex(n4, n10++ & 3));
                        ++n7;
                    }
                }
                list.add(byteBuf2);
            } else if (byteBuf2.writableBytes() >= byteBuf.readableBytes()) {
                byteBuf2.writeBytes(byteBuf);
                list.add(byteBuf2);
            } else {
                list.add(byteBuf2);
                list.add(byteBuf.retain());
            }
            bl = false;
        }
        finally {
            if (bl && byteBuf2 != null) {
                byteBuf2.release();
            }
        }
    }
}

