/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.CharsetUtil;

public class WebSocketServerHandshaker13
extends WebSocketServerHandshaker {
    public static final String WEBSOCKET_13_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";

    public WebSocketServerHandshaker13(String string, String string2, boolean bl, int n) {
        this(string, string2, bl, n, false);
    }

    public WebSocketServerHandshaker13(String string, String string2, boolean bl, int n, boolean bl2) {
        this(string, string2, WebSocketDecoderConfig.newBuilder().allowExtensions(bl).maxFramePayloadLength(n).allowMaskMismatch(bl2).build());
    }

    public WebSocketServerHandshaker13(String string, String string2, WebSocketDecoderConfig webSocketDecoderConfig) {
        super(WebSocketVersion.V13, string, string2, webSocketDecoderConfig);
    }

    @Override
    protected FullHttpResponse newHandshakeResponse(FullHttpRequest fullHttpRequest, HttpHeaders httpHeaders) {
        HttpMethod httpMethod = fullHttpRequest.method();
        if (!HttpMethod.GET.equals(httpMethod)) {
            throw new WebSocketServerHandshakeException("Invalid WebSocket handshake method: " + httpMethod, fullHttpRequest);
        }
        HttpHeaders httpHeaders2 = fullHttpRequest.headers();
        if (!httpHeaders2.contains((CharSequence)HttpHeaderNames.CONNECTION) || !httpHeaders2.containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true)) {
            throw new WebSocketServerHandshakeException("not a WebSocket request: a |Connection| header must includes a token 'Upgrade'", fullHttpRequest);
        }
        if (!httpHeaders2.contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true)) {
            throw new WebSocketServerHandshakeException("not a WebSocket request: a |Upgrade| header must containing the value 'websocket'", fullHttpRequest);
        }
        String string = httpHeaders2.get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY);
        if (string == null) {
            throw new WebSocketServerHandshakeException("not a WebSocket request: missing key", fullHttpRequest);
        }
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, fullHttpRequest.content().alloc().buffer(0));
        if (httpHeaders != null) {
            defaultFullHttpResponse.headers().add(httpHeaders);
        }
        String string2 = string + WEBSOCKET_13_ACCEPT_GUID;
        byte[] byArray = WebSocketUtil.sha1(string2.getBytes(CharsetUtil.US_ASCII));
        String string3 = WebSocketUtil.base64(byArray);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 13 server handshake key: {}, response: {}", (Object)string, (Object)string3);
        }
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT, (Object)string3);
        String string4 = httpHeaders2.get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        if (string4 != null) {
            String string5 = this.selectSubprotocol(string4);
            if (string5 == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Requested subprotocol(s) not supported: {}", (Object)string4);
                }
            } else {
                defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)string5);
            }
        }
        return defaultFullHttpResponse;
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket13FrameDecoder(this.decoderConfig());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket13FrameEncoder(false);
    }
}

